/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.uploadable;

import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.client.utils.InputStreamPumper;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class PodUpload {
    private static final String TAR_PATH_DELIMITER = "/";

    private PodUpload() {
    }

    public static boolean upload(PodOperationsImpl operation, Path pathToUpload) throws IOException {
        if (Utils.isNotNullOrEmpty(operation.getContext().getFile()) && pathToUpload.toFile().isFile()) {
            return PodUpload.uploadFile(operation, pathToUpload);
        }
        if (Utils.isNotNullOrEmpty(operation.getContext().getDir()) && pathToUpload.toFile().isDirectory()) {
            return PodUpload.uploadDirectory(operation, pathToUpload);
        }
        throw new IllegalArgumentException("Provided arguments are not valid (file, directory, path)");
    }

    private static boolean upload(PodOperationsImpl operation, String command, UploadProcessor processor) throws IOException {
        CompletableFuture<Integer> exitFuture;
        operation = operation.redirectingInput().terminateOnError();
        try (ExecWatch execWatch = operation.exec("sh", "-c", command);){
            OutputStream out = execWatch.getInput();
            processor.process(out);
            out.close();
            exitFuture = execWatch.exitCode();
        }
        if (!Utils.waitUntilReady(exitFuture, operation.getRequestConfig().getUploadRequestTimeout(), TimeUnit.MILLISECONDS)) {
            return false;
        }
        Integer exitCode = exitFuture.getNow(null);
        return exitCode == null || exitCode == 0;
    }

    public static boolean uploadFileData(PodOperationsImpl operation, InputStream inputStream2) throws IOException {
        String command = PodUpload.createExecCommandForUpload(operation.getContext().getFile());
        return PodUpload.upload(operation, command, os -> InputStreamPumper.transferTo(inputStream2, os::write));
    }

    private static boolean uploadFile(PodOperationsImpl operation, Path pathToUpload) throws IOException {
        try (FileInputStream fis = new FileInputStream(pathToUpload.toFile());){
            boolean bl = PodUpload.uploadFileData(operation, fis);
            return bl;
        }
    }

    private static boolean uploadDirectory(PodOperationsImpl operation, Path pathToUpload) throws IOException {
        String command = String.format("mkdir -p %1$s && tar -C %1$s -xzf -", PodOperationsImpl.shellQuote(operation.getContext().getDir()));
        return PodUpload.upload(operation, command, os -> {
            try (GZIPOutputStream gzip = new GZIPOutputStream(os);
                 TarArchiveOutputStream tar = new TarArchiveOutputStream((OutputStream)gzip);){
                tar.setLongFileMode(3);
                for (File file : pathToUpload.toFile().listFiles()) {
                    PodUpload.addFileToTar(null, file, tar);
                }
                tar.flush();
            }
        });
    }

    private static void addFileToTar(String rootTarPath, File file, TarArchiveOutputStream tar) throws IOException {
        String fileName = Optional.ofNullable(rootTarPath).orElse("") + TAR_PATH_DELIMITER + file.getName();
        tar.putArchiveEntry((ArchiveEntry)new TarArchiveEntry(file, fileName));
        if (file.isFile()) {
            Files.copy(file.toPath(), (OutputStream)tar);
            tar.closeArchiveEntry();
        } else if (file.isDirectory()) {
            tar.closeArchiveEntry();
            for (File fileInDirectory : file.listFiles()) {
                PodUpload.addFileToTar(fileName, fileInDirectory, tar);
            }
        }
    }

    static String createExecCommandForUpload(String file) {
        String directoryTrimmedFromFilePath = file.substring(0, file.lastIndexOf(47));
        String directory = directoryTrimmedFromFilePath.isEmpty() ? TAR_PATH_DELIMITER : directoryTrimmedFromFilePath;
        return String.format("mkdir -p %s && cat - > %s", PodOperationsImpl.shellQuote(directory), PodOperationsImpl.shellQuote(file));
    }

    private static interface UploadProcessor {
        public void process(OutputStream var1) throws IOException;
    }
}

