/*
 * Decompiled with CFR 0.152.
 */
package dev.parodos.move2kube.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import dev.parodos.move2kube.JSON;
import dev.parodos.move2kube.client.model.Project;
import dev.parodos.move2kube.client.model.ProjectInputsValue;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Workspace {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private OffsetDateTime timestamp;
    public static final String SERIALIZED_NAME_PROJECT_IDS = "project_ids";
    @SerializedName(value="project_ids")
    private List<String> projectIds;
    public static final String SERIALIZED_NAME_INPUTS = "inputs";
    @SerializedName(value="inputs")
    private Map<String, ProjectInputsValue> inputs = new HashMap<String, ProjectInputsValue>();
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_PROJECTS = "projects";
    @SerializedName(value="projects")
    private List<Project> projects;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Workspace id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Workspace name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Workspace timestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public Workspace projectIds(List<String> projectIds) {
        this.projectIds = projectIds;
        return this;
    }

    public Workspace addProjectIdsItem(String projectIdsItem) {
        if (this.projectIds == null) {
            this.projectIds = new ArrayList<String>();
        }
        this.projectIds.add(projectIdsItem);
        return this;
    }

    @Nullable
    public List<String> getProjectIds() {
        return this.projectIds;
    }

    public void setProjectIds(List<String> projectIds) {
        this.projectIds = projectIds;
    }

    public Workspace inputs(Map<String, ProjectInputsValue> inputs) {
        this.inputs = inputs;
        return this;
    }

    public Workspace putInputsItem(String key, ProjectInputsValue inputsItem) {
        if (this.inputs == null) {
            this.inputs = new HashMap<String, ProjectInputsValue>();
        }
        this.inputs.put(key, inputsItem);
        return this;
    }

    @Nullable
    public Map<String, ProjectInputsValue> getInputs() {
        return this.inputs;
    }

    public void setInputs(Map<String, ProjectInputsValue> inputs) {
        this.inputs = inputs;
    }

    public Workspace description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Workspace projects(List<Project> projects) {
        this.projects = projects;
        return this;
    }

    public Workspace addProjectsItem(Project projectsItem) {
        if (this.projects == null) {
            this.projects = new ArrayList<Project>();
        }
        this.projects.add(projectsItem);
        return this;
    }

    @Nullable
    public List<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Project> projects) {
        this.projects = projects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workspace workspace = (Workspace)o;
        return Objects.equals(this.id, workspace.id) && Objects.equals(this.name, workspace.name) && Objects.equals(this.timestamp, workspace.timestamp) && Objects.equals(this.projectIds, workspace.projectIds) && Objects.equals(this.inputs, workspace.inputs) && Objects.equals(this.description, workspace.description) && Objects.equals(this.projects, workspace.projects);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.timestamp, this.projectIds, this.inputs, this.description, this.projects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Workspace {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    projectIds: ").append(this.toIndentedString(this.projectIds)).append("\n");
        sb.append("    inputs: ").append(this.toIndentedString(this.inputs)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    projects: ").append(this.toIndentedString(this.projects)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayprojects;
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Workspace is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set<Map.Entry<String, JsonElement>> entries = jsonObj.entrySet();
        for (Map.Entry<String, JsonElement> entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Workspace` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROJECT_IDS) != null && !jsonObj.get(SERIALIZED_NAME_PROJECT_IDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `project_ids` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROJECT_IDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROJECTS) != null && !jsonObj.get(SERIALIZED_NAME_PROJECTS).isJsonNull() && (jsonArrayprojects = jsonObj.getAsJsonArray(SERIALIZED_NAME_PROJECTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PROJECTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `projects` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROJECTS).toString()));
            }
            for (int i = 0; i < jsonArrayprojects.size(); ++i) {
                Project.validateJsonObject(jsonArrayprojects.get(i).getAsJsonObject());
            }
        }
    }

    public static Workspace fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, Workspace.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_TIMESTAMP);
        openapiFields.add(SERIALIZED_NAME_PROJECT_IDS);
        openapiFields.add(SERIALIZED_NAME_INPUTS);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_PROJECTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Workspace.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<Workspace> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(Workspace.class));
            return new TypeAdapter<Workspace>(){

                @Override
                public void write(JsonWriter out, Workspace value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    elementAdapter.write(out, obj);
                }

                @Override
                public Workspace read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Workspace.validateJsonObject(jsonObj);
                    return (Workspace)thisAdapter.fromJsonTree(jsonObj);
                }
            }.nullSafe();
        }
    }
}

