/*
 * Decompiled with CFR 0.152.
 */
package dev.parodos.move2kube.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import dev.parodos.move2kube.JSON;
import dev.parodos.move2kube.client.model.ProjectInputsValue;
import dev.parodos.move2kube.client.model.ProjectOutputsValue;
import dev.parodos.move2kube.client.model.ProjectStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Project {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private OffsetDateTime timestamp;
    public static final String SERIALIZED_NAME_OUTPUTS = "outputs";
    @SerializedName(value="outputs")
    private Map<String, ProjectOutputsValue> outputs = new HashMap<String, ProjectOutputsValue>();
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private ProjectStatus status;
    public static final String SERIALIZED_NAME_INPUTS = "inputs";
    @SerializedName(value="inputs")
    private Map<String, ProjectInputsValue> inputs = new HashMap<String, ProjectInputsValue>();
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Project id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Project name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Project timestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public Project outputs(Map<String, ProjectOutputsValue> outputs) {
        this.outputs = outputs;
        return this;
    }

    public Project putOutputsItem(String key, ProjectOutputsValue outputsItem) {
        if (this.outputs == null) {
            this.outputs = new HashMap<String, ProjectOutputsValue>();
        }
        this.outputs.put(key, outputsItem);
        return this;
    }

    @Nullable
    public Map<String, ProjectOutputsValue> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Map<String, ProjectOutputsValue> outputs) {
        this.outputs = outputs;
    }

    public Project status(ProjectStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    public ProjectStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProjectStatus status) {
        this.status = status;
    }

    public Project inputs(Map<String, ProjectInputsValue> inputs) {
        this.inputs = inputs;
        return this;
    }

    public Project putInputsItem(String key, ProjectInputsValue inputsItem) {
        if (this.inputs == null) {
            this.inputs = new HashMap<String, ProjectInputsValue>();
        }
        this.inputs.put(key, inputsItem);
        return this;
    }

    @Nullable
    public Map<String, ProjectInputsValue> getInputs() {
        return this.inputs;
    }

    public void setInputs(Map<String, ProjectInputsValue> inputs) {
        this.inputs = inputs;
    }

    public Project description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Project project = (Project)o;
        return Objects.equals(this.id, project.id) && Objects.equals(this.name, project.name) && Objects.equals(this.timestamp, project.timestamp) && Objects.equals(this.outputs, project.outputs) && Objects.equals(this.status, project.status) && Objects.equals(this.inputs, project.inputs) && Objects.equals(this.description, project.description);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.timestamp, this.outputs, this.status, this.inputs, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Project {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    outputs: ").append(this.toIndentedString(this.outputs)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    inputs: ").append(this.toIndentedString(this.inputs)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Project is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set<Map.Entry<String, JsonElement>> entries = jsonObj.entrySet();
        for (Map.Entry<String, JsonElement> entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Project` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull()) {
            ProjectStatus.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_STATUS));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
    }

    public static Project fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, Project.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_TIMESTAMP);
        openapiFields.add(SERIALIZED_NAME_OUTPUTS);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_INPUTS);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Project.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<Project> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(Project.class));
            return new TypeAdapter<Project>(){

                @Override
                public void write(JsonWriter out, Project value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    elementAdapter.write(out, obj);
                }

                @Override
                public Project read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Project.validateJsonObject(jsonObj);
                    return (Project)thisAdapter.fromJsonTree(jsonObj);
                }
            }.nullSafe();
        }
    }
}

