/*
 * Decompiled with CFR 0.152.
 */
package dev.parodos.move2kube.api;

import com.google.gson.reflect.TypeToken;
import dev.parodos.move2kube.ApiCallback;
import dev.parodos.move2kube.ApiClient;
import dev.parodos.move2kube.ApiException;
import dev.parodos.move2kube.ApiResponse;
import dev.parodos.move2kube.Configuration;
import dev.parodos.move2kube.Pair;
import dev.parodos.move2kube.client.model.CreateWorkspaceInput201Response;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class WorkspaceInputsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WorkspaceInputsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkspaceInputsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createWorkspaceInputCall(String workspaceId, String type, String description, File _file, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workspaces/{workspace-id}/inputs".replace("{workspace-id}", this.localVarApiClient.escapeString(workspaceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarFormParams.put("type", type);
        }
        if (description != null) {
            localVarFormParams.put("description", description);
        }
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createWorkspaceInputValidateBeforeCall(String workspaceId, String type, String description, File _file, ApiCallback _callback) throws ApiException {
        if (workspaceId == null) {
            throw new ApiException("Missing the required parameter 'workspaceId' when calling createWorkspaceInput(Async)");
        }
        return this.createWorkspaceInputCall(workspaceId, type, description, _file, _callback);
    }

    public CreateWorkspaceInput201Response createWorkspaceInput(String workspaceId, String type, String description, File _file) throws ApiException {
        ApiResponse<CreateWorkspaceInput201Response> localVarResp = this.createWorkspaceInputWithHttpInfo(workspaceId, type, description, _file);
        return localVarResp.getData();
    }

    public ApiResponse<CreateWorkspaceInput201Response> createWorkspaceInputWithHttpInfo(String workspaceId, String type, String description, File _file) throws ApiException {
        Call localVarCall = this.createWorkspaceInputValidateBeforeCall(workspaceId, type, description, _file, null);
        Type localVarReturnType = new TypeToken<CreateWorkspaceInput201Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createWorkspaceInputAsync(String workspaceId, String type, String description, File _file, ApiCallback<CreateWorkspaceInput201Response> _callback) throws ApiException {
        Call localVarCall = this.createWorkspaceInputValidateBeforeCall(workspaceId, type, description, _file, _callback);
        Type localVarReturnType = new TypeToken<CreateWorkspaceInput201Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteWorkspaceInputCall(String workspaceId, String inputId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workspaces/{workspace-id}/inputs/{input-id}".replace("{workspace-id}", this.localVarApiClient.escapeString(workspaceId.toString())).replace("{input-id}", this.localVarApiClient.escapeString(inputId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteWorkspaceInputValidateBeforeCall(String workspaceId, String inputId, ApiCallback _callback) throws ApiException {
        if (workspaceId == null) {
            throw new ApiException("Missing the required parameter 'workspaceId' when calling deleteWorkspaceInput(Async)");
        }
        if (inputId == null) {
            throw new ApiException("Missing the required parameter 'inputId' when calling deleteWorkspaceInput(Async)");
        }
        return this.deleteWorkspaceInputCall(workspaceId, inputId, _callback);
    }

    public void deleteWorkspaceInput(String workspaceId, String inputId) throws ApiException {
        this.deleteWorkspaceInputWithHttpInfo(workspaceId, inputId);
    }

    public ApiResponse<Void> deleteWorkspaceInputWithHttpInfo(String workspaceId, String inputId) throws ApiException {
        Call localVarCall = this.deleteWorkspaceInputValidateBeforeCall(workspaceId, inputId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteWorkspaceInputAsync(String workspaceId, String inputId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteWorkspaceInputValidateBeforeCall(workspaceId, inputId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getWorkspaceInputCall(String workspaceId, String inputId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workspaces/{workspace-id}/inputs/{input-id}".replace("{workspace-id}", this.localVarApiClient.escapeString(workspaceId.toString())).replace("{input-id}", this.localVarApiClient.escapeString(inputId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWorkspaceInputValidateBeforeCall(String workspaceId, String inputId, ApiCallback _callback) throws ApiException {
        if (workspaceId == null) {
            throw new ApiException("Missing the required parameter 'workspaceId' when calling getWorkspaceInput(Async)");
        }
        if (inputId == null) {
            throw new ApiException("Missing the required parameter 'inputId' when calling getWorkspaceInput(Async)");
        }
        return this.getWorkspaceInputCall(workspaceId, inputId, _callback);
    }

    public File getWorkspaceInput(String workspaceId, String inputId) throws ApiException {
        ApiResponse<File> localVarResp = this.getWorkspaceInputWithHttpInfo(workspaceId, inputId);
        return localVarResp.getData();
    }

    public ApiResponse<File> getWorkspaceInputWithHttpInfo(String workspaceId, String inputId) throws ApiException {
        Call localVarCall = this.getWorkspaceInputValidateBeforeCall(workspaceId, inputId, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getWorkspaceInputAsync(String workspaceId, String inputId, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getWorkspaceInputValidateBeforeCall(workspaceId, inputId, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

