/*
 * Decompiled with CFR 0.152.
 */
package dev.parodos.move2kube.api;

import com.google.gson.reflect.TypeToken;
import dev.parodos.move2kube.ApiCallback;
import dev.parodos.move2kube.ApiClient;
import dev.parodos.move2kube.ApiException;
import dev.parodos.move2kube.ApiResponse;
import dev.parodos.move2kube.Configuration;
import dev.parodos.move2kube.Pair;
import dev.parodos.move2kube.client.model.GetCurrentQuestion200Response;
import dev.parodos.move2kube.client.model.PostAnswerToQuestionRequest;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class QaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public QaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public QaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getCurrentQuestionCall(String workspaceId, String projectId, String outputId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workspaces/{workspace-id}/projects/{project-id}/outputs/{output-id}/problems/current".replace("{workspace-id}", this.localVarApiClient.escapeString(workspaceId.toString())).replace("{project-id}", this.localVarApiClient.escapeString(projectId.toString())).replace("{output-id}", this.localVarApiClient.escapeString(outputId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCurrentQuestionValidateBeforeCall(String workspaceId, String projectId, String outputId, ApiCallback _callback) throws ApiException {
        if (workspaceId == null) {
            throw new ApiException("Missing the required parameter 'workspaceId' when calling getCurrentQuestion(Async)");
        }
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getCurrentQuestion(Async)");
        }
        if (outputId == null) {
            throw new ApiException("Missing the required parameter 'outputId' when calling getCurrentQuestion(Async)");
        }
        return this.getCurrentQuestionCall(workspaceId, projectId, outputId, _callback);
    }

    public GetCurrentQuestion200Response getCurrentQuestion(String workspaceId, String projectId, String outputId) throws ApiException {
        ApiResponse<GetCurrentQuestion200Response> localVarResp = this.getCurrentQuestionWithHttpInfo(workspaceId, projectId, outputId);
        return localVarResp.getData();
    }

    public ApiResponse<GetCurrentQuestion200Response> getCurrentQuestionWithHttpInfo(String workspaceId, String projectId, String outputId) throws ApiException {
        Call localVarCall = this.getCurrentQuestionValidateBeforeCall(workspaceId, projectId, outputId, null);
        Type localVarReturnType = new TypeToken<GetCurrentQuestion200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCurrentQuestionAsync(String workspaceId, String projectId, String outputId, ApiCallback<GetCurrentQuestion200Response> _callback) throws ApiException {
        Call localVarCall = this.getCurrentQuestionValidateBeforeCall(workspaceId, projectId, outputId, _callback);
        Type localVarReturnType = new TypeToken<GetCurrentQuestion200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postAnswerToQuestionCall(String workspaceId, String projectId, String outputId, PostAnswerToQuestionRequest body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PostAnswerToQuestionRequest localVarPostBody = body;
        String localVarPath = "/workspaces/{workspace-id}/projects/{project-id}/outputs/{output-id}/problems/current/solution".replace("{workspace-id}", this.localVarApiClient.escapeString(workspaceId.toString())).replace("{project-id}", this.localVarApiClient.escapeString(projectId.toString())).replace("{output-id}", this.localVarApiClient.escapeString(outputId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postAnswerToQuestionValidateBeforeCall(String workspaceId, String projectId, String outputId, PostAnswerToQuestionRequest body, ApiCallback _callback) throws ApiException {
        if (workspaceId == null) {
            throw new ApiException("Missing the required parameter 'workspaceId' when calling postAnswerToQuestion(Async)");
        }
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling postAnswerToQuestion(Async)");
        }
        if (outputId == null) {
            throw new ApiException("Missing the required parameter 'outputId' when calling postAnswerToQuestion(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling postAnswerToQuestion(Async)");
        }
        return this.postAnswerToQuestionCall(workspaceId, projectId, outputId, body, _callback);
    }

    public void postAnswerToQuestion(String workspaceId, String projectId, String outputId, PostAnswerToQuestionRequest body) throws ApiException {
        this.postAnswerToQuestionWithHttpInfo(workspaceId, projectId, outputId, body);
    }

    public ApiResponse<Void> postAnswerToQuestionWithHttpInfo(String workspaceId, String projectId, String outputId, PostAnswerToQuestionRequest body) throws ApiException {
        Call localVarCall = this.postAnswerToQuestionValidateBeforeCall(workspaceId, projectId, outputId, body, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call postAnswerToQuestionAsync(String workspaceId, String projectId, String outputId, PostAnswerToQuestionRequest body, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.postAnswerToQuestionValidateBeforeCall(workspaceId, projectId, outputId, body, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

