/*
 * Decompiled with CFR 0.152.
 */
package dev.parodos.move2kube.api;

import com.google.gson.reflect.TypeToken;
import dev.parodos.move2kube.ApiCallback;
import dev.parodos.move2kube.ApiClient;
import dev.parodos.move2kube.ApiException;
import dev.parodos.move2kube.ApiResponse;
import dev.parodos.move2kube.Configuration;
import dev.parodos.move2kube.Pair;
import dev.parodos.move2kube.client.model.CreateProject201Response;
import dev.parodos.move2kube.client.model.Project;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class ProjectsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ProjectsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProjectsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createProjectCall(String workspaceId, Project body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Project localVarPostBody = body;
        String localVarPath = "/workspaces/{workspace-id}/projects".replace("{workspace-id}", this.localVarApiClient.escapeString(workspaceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createProjectValidateBeforeCall(String workspaceId, Project body, ApiCallback _callback) throws ApiException {
        if (workspaceId == null) {
            throw new ApiException("Missing the required parameter 'workspaceId' when calling createProject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createProject(Async)");
        }
        return this.createProjectCall(workspaceId, body, _callback);
    }

    public CreateProject201Response createProject(String workspaceId, Project body) throws ApiException {
        ApiResponse<CreateProject201Response> localVarResp = this.createProjectWithHttpInfo(workspaceId, body);
        return localVarResp.getData();
    }

    public ApiResponse<CreateProject201Response> createProjectWithHttpInfo(String workspaceId, Project body) throws ApiException {
        Call localVarCall = this.createProjectValidateBeforeCall(workspaceId, body, null);
        Type localVarReturnType = new TypeToken<CreateProject201Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createProjectAsync(String workspaceId, Project body, ApiCallback<CreateProject201Response> _callback) throws ApiException {
        Call localVarCall = this.createProjectValidateBeforeCall(workspaceId, body, _callback);
        Type localVarReturnType = new TypeToken<CreateProject201Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteProjectCall(String workspaceId, String projectId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workspaces/{workspace-id}/projects/{project-id}".replace("{workspace-id}", this.localVarApiClient.escapeString(workspaceId.toString())).replace("{project-id}", this.localVarApiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProjectValidateBeforeCall(String workspaceId, String projectId, ApiCallback _callback) throws ApiException {
        if (workspaceId == null) {
            throw new ApiException("Missing the required parameter 'workspaceId' when calling deleteProject(Async)");
        }
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling deleteProject(Async)");
        }
        return this.deleteProjectCall(workspaceId, projectId, _callback);
    }

    public void deleteProject(String workspaceId, String projectId) throws ApiException {
        this.deleteProjectWithHttpInfo(workspaceId, projectId);
    }

    public ApiResponse<Void> deleteProjectWithHttpInfo(String workspaceId, String projectId) throws ApiException {
        Call localVarCall = this.deleteProjectValidateBeforeCall(workspaceId, projectId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteProjectAsync(String workspaceId, String projectId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteProjectValidateBeforeCall(workspaceId, projectId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getProjectCall(String workspaceId, String projectId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workspaces/{workspace-id}/projects/{project-id}".replace("{workspace-id}", this.localVarApiClient.escapeString(workspaceId.toString())).replace("{project-id}", this.localVarApiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProjectValidateBeforeCall(String workspaceId, String projectId, ApiCallback _callback) throws ApiException {
        if (workspaceId == null) {
            throw new ApiException("Missing the required parameter 'workspaceId' when calling getProject(Async)");
        }
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getProject(Async)");
        }
        return this.getProjectCall(workspaceId, projectId, _callback);
    }

    public Project getProject(String workspaceId, String projectId) throws ApiException {
        ApiResponse<Project> localVarResp = this.getProjectWithHttpInfo(workspaceId, projectId);
        return localVarResp.getData();
    }

    public ApiResponse<Project> getProjectWithHttpInfo(String workspaceId, String projectId) throws ApiException {
        Call localVarCall = this.getProjectValidateBeforeCall(workspaceId, projectId, null);
        Type localVarReturnType = new TypeToken<Project>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProjectAsync(String workspaceId, String projectId, ApiCallback<Project> _callback) throws ApiException {
        Call localVarCall = this.getProjectValidateBeforeCall(workspaceId, projectId, _callback);
        Type localVarReturnType = new TypeToken<Project>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProjectsCall(String workspaceId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workspaces/{workspace-id}/projects".replace("{workspace-id}", this.localVarApiClient.escapeString(workspaceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProjectsValidateBeforeCall(String workspaceId, ApiCallback _callback) throws ApiException {
        if (workspaceId == null) {
            throw new ApiException("Missing the required parameter 'workspaceId' when calling getProjects(Async)");
        }
        return this.getProjectsCall(workspaceId, _callback);
    }

    public List<Project> getProjects(String workspaceId) throws ApiException {
        ApiResponse<List<Project>> localVarResp = this.getProjectsWithHttpInfo(workspaceId);
        return localVarResp.getData();
    }

    public ApiResponse<List<Project>> getProjectsWithHttpInfo(String workspaceId) throws ApiException {
        Call localVarCall = this.getProjectsValidateBeforeCall(workspaceId, null);
        Type localVarReturnType = new TypeToken<List<Project>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProjectsAsync(String workspaceId, ApiCallback<List<Project>> _callback) throws ApiException {
        Call localVarCall = this.getProjectsValidateBeforeCall(workspaceId, _callback);
        Type localVarReturnType = new TypeToken<List<Project>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateProjectCall(String workspaceId, String projectId, Project body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Project localVarPostBody = body;
        String localVarPath = "/workspaces/{workspace-id}/projects/{project-id}".replace("{workspace-id}", this.localVarApiClient.escapeString(workspaceId.toString())).replace("{project-id}", this.localVarApiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateProjectValidateBeforeCall(String workspaceId, String projectId, Project body, ApiCallback _callback) throws ApiException {
        if (workspaceId == null) {
            throw new ApiException("Missing the required parameter 'workspaceId' when calling updateProject(Async)");
        }
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling updateProject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateProject(Async)");
        }
        return this.updateProjectCall(workspaceId, projectId, body, _callback);
    }

    public void updateProject(String workspaceId, String projectId, Project body) throws ApiException {
        this.updateProjectWithHttpInfo(workspaceId, projectId, body);
    }

    public ApiResponse<Void> updateProjectWithHttpInfo(String workspaceId, String projectId, Project body) throws ApiException {
        Call localVarCall = this.updateProjectValidateBeforeCall(workspaceId, projectId, body, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateProjectAsync(String workspaceId, String projectId, Project body, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateProjectValidateBeforeCall(workspaceId, projectId, body, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

