/*
 * Decompiled with CFR 0.152.
 */
package dev.parodos.move2kube.api;

import com.google.gson.reflect.TypeToken;
import dev.parodos.move2kube.ApiCallback;
import dev.parodos.move2kube.ApiClient;
import dev.parodos.move2kube.ApiException;
import dev.parodos.move2kube.ApiResponse;
import dev.parodos.move2kube.Configuration;
import dev.parodos.move2kube.Pair;
import dev.parodos.move2kube.client.model.StartTransformation202Response;
import dev.parodos.move2kube.client.model.StartTransformationRequest;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ProjectOutputsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ProjectOutputsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProjectOutputsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteProjectOutputCall(String workspaceId, String projectId, String outputId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workspaces/{workspace-id}/projects/{project-id}/outputs/{output-id}".replace("{workspace-id}", this.localVarApiClient.escapeString(workspaceId.toString())).replace("{project-id}", this.localVarApiClient.escapeString(projectId.toString())).replace("{output-id}", this.localVarApiClient.escapeString(outputId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProjectOutputValidateBeforeCall(String workspaceId, String projectId, String outputId, ApiCallback _callback) throws ApiException {
        if (workspaceId == null) {
            throw new ApiException("Missing the required parameter 'workspaceId' when calling deleteProjectOutput(Async)");
        }
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling deleteProjectOutput(Async)");
        }
        if (outputId == null) {
            throw new ApiException("Missing the required parameter 'outputId' when calling deleteProjectOutput(Async)");
        }
        return this.deleteProjectOutputCall(workspaceId, projectId, outputId, _callback);
    }

    public void deleteProjectOutput(String workspaceId, String projectId, String outputId) throws ApiException {
        this.deleteProjectOutputWithHttpInfo(workspaceId, projectId, outputId);
    }

    public ApiResponse<Void> deleteProjectOutputWithHttpInfo(String workspaceId, String projectId, String outputId) throws ApiException {
        Call localVarCall = this.deleteProjectOutputValidateBeforeCall(workspaceId, projectId, outputId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteProjectOutputAsync(String workspaceId, String projectId, String outputId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteProjectOutputValidateBeforeCall(workspaceId, projectId, outputId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getProjectOutputCall(String workspaceId, String projectId, String outputId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workspaces/{workspace-id}/projects/{project-id}/outputs/{output-id}".replace("{workspace-id}", this.localVarApiClient.escapeString(workspaceId.toString())).replace("{project-id}", this.localVarApiClient.escapeString(projectId.toString())).replace("{output-id}", this.localVarApiClient.escapeString(outputId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProjectOutputValidateBeforeCall(String workspaceId, String projectId, String outputId, ApiCallback _callback) throws ApiException {
        if (workspaceId == null) {
            throw new ApiException("Missing the required parameter 'workspaceId' when calling getProjectOutput(Async)");
        }
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getProjectOutput(Async)");
        }
        if (outputId == null) {
            throw new ApiException("Missing the required parameter 'outputId' when calling getProjectOutput(Async)");
        }
        return this.getProjectOutputCall(workspaceId, projectId, outputId, _callback);
    }

    public File getProjectOutput(String workspaceId, String projectId, String outputId) throws ApiException {
        ApiResponse<File> localVarResp = this.getProjectOutputWithHttpInfo(workspaceId, projectId, outputId);
        return localVarResp.getData();
    }

    public ApiResponse<File> getProjectOutputWithHttpInfo(String workspaceId, String projectId, String outputId) throws ApiException {
        Call localVarCall = this.getProjectOutputValidateBeforeCall(workspaceId, projectId, outputId, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProjectOutputAsync(String workspaceId, String projectId, String outputId, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getProjectOutputValidateBeforeCall(workspaceId, projectId, outputId, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call startTransformationCall(String workspaceId, String projectId, StartTransformationRequest body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        StartTransformationRequest localVarPostBody = body;
        String localVarPath = "/workspaces/{workspace-id}/projects/{project-id}/outputs".replace("{workspace-id}", this.localVarApiClient.escapeString(workspaceId.toString())).replace("{project-id}", this.localVarApiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call startTransformationValidateBeforeCall(String workspaceId, String projectId, StartTransformationRequest body, ApiCallback _callback) throws ApiException {
        if (workspaceId == null) {
            throw new ApiException("Missing the required parameter 'workspaceId' when calling startTransformation(Async)");
        }
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling startTransformation(Async)");
        }
        return this.startTransformationCall(workspaceId, projectId, body, _callback);
    }

    public StartTransformation202Response startTransformation(String workspaceId, String projectId, StartTransformationRequest body) throws ApiException {
        ApiResponse<StartTransformation202Response> localVarResp = this.startTransformationWithHttpInfo(workspaceId, projectId, body);
        return localVarResp.getData();
    }

    public ApiResponse<StartTransformation202Response> startTransformationWithHttpInfo(String workspaceId, String projectId, StartTransformationRequest body) throws ApiException {
        Call localVarCall = this.startTransformationValidateBeforeCall(workspaceId, projectId, body, null);
        Type localVarReturnType = new TypeToken<StartTransformation202Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call startTransformationAsync(String workspaceId, String projectId, StartTransformationRequest body, ApiCallback<StartTransformation202Response> _callback) throws ApiException {
        Call localVarCall = this.startTransformationValidateBeforeCall(workspaceId, projectId, body, _callback);
        Type localVarReturnType = new TypeToken<StartTransformation202Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

