/*
 * Decompiled with CFR 0.152.
 */
package dev.parodos.move2kube.api;

import com.google.gson.reflect.TypeToken;
import dev.parodos.move2kube.ApiCallback;
import dev.parodos.move2kube.ApiClient;
import dev.parodos.move2kube.ApiException;
import dev.parodos.move2kube.ApiResponse;
import dev.parodos.move2kube.Configuration;
import dev.parodos.move2kube.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ProjectOutputGraphsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ProjectOutputGraphsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProjectOutputGraphsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getProjectOutputGraphCall(String workspaceId, String projectId, String outputId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workspaces/{workspace-id}/projects/{project-id}/outputs/{output-id}/graph".replace("{workspace-id}", this.localVarApiClient.escapeString(workspaceId.toString())).replace("{project-id}", this.localVarApiClient.escapeString(projectId.toString())).replace("{output-id}", this.localVarApiClient.escapeString(outputId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProjectOutputGraphValidateBeforeCall(String workspaceId, String projectId, String outputId, ApiCallback _callback) throws ApiException {
        if (workspaceId == null) {
            throw new ApiException("Missing the required parameter 'workspaceId' when calling getProjectOutputGraph(Async)");
        }
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getProjectOutputGraph(Async)");
        }
        if (outputId == null) {
            throw new ApiException("Missing the required parameter 'outputId' when calling getProjectOutputGraph(Async)");
        }
        return this.getProjectOutputGraphCall(workspaceId, projectId, outputId, _callback);
    }

    public Object getProjectOutputGraph(String workspaceId, String projectId, String outputId) throws ApiException {
        ApiResponse<Object> localVarResp = this.getProjectOutputGraphWithHttpInfo(workspaceId, projectId, outputId);
        return localVarResp.getData();
    }

    public ApiResponse<Object> getProjectOutputGraphWithHttpInfo(String workspaceId, String projectId, String outputId) throws ApiException {
        Call localVarCall = this.getProjectOutputGraphValidateBeforeCall(workspaceId, projectId, outputId, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProjectOutputGraphAsync(String workspaceId, String projectId, String outputId, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getProjectOutputGraphValidateBeforeCall(workspaceId, projectId, outputId, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

