/*
 * Decompiled with CFR 0.152.
 */
package dev.parodos.move2kube.api;

import com.google.gson.reflect.TypeToken;
import dev.parodos.move2kube.ApiCallback;
import dev.parodos.move2kube.ApiClient;
import dev.parodos.move2kube.ApiException;
import dev.parodos.move2kube.ApiResponse;
import dev.parodos.move2kube.Configuration;
import dev.parodos.move2kube.Pair;
import dev.parodos.move2kube.client.model.CreateProjectInput201Response;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ProjectInputsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ProjectInputsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProjectInputsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createProjectInputCall(String workspaceId, String projectId, String type, String id, String description, File _file, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workspaces/{workspace-id}/projects/{project-id}/inputs".replace("{workspace-id}", this.localVarApiClient.escapeString(workspaceId.toString())).replace("{project-id}", this.localVarApiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarFormParams.put("type", type);
        }
        if (id != null) {
            localVarFormParams.put("id", id);
        }
        if (description != null) {
            localVarFormParams.put("description", description);
        }
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createProjectInputValidateBeforeCall(String workspaceId, String projectId, String type, String id, String description, File _file, ApiCallback _callback) throws ApiException {
        if (workspaceId == null) {
            throw new ApiException("Missing the required parameter 'workspaceId' when calling createProjectInput(Async)");
        }
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling createProjectInput(Async)");
        }
        return this.createProjectInputCall(workspaceId, projectId, type, id, description, _file, _callback);
    }

    public CreateProjectInput201Response createProjectInput(String workspaceId, String projectId, String type, String id, String description, File _file) throws ApiException {
        ApiResponse<CreateProjectInput201Response> localVarResp = this.createProjectInputWithHttpInfo(workspaceId, projectId, type, id, description, _file);
        return localVarResp.getData();
    }

    public ApiResponse<CreateProjectInput201Response> createProjectInputWithHttpInfo(String workspaceId, String projectId, String type, String id, String description, File _file) throws ApiException {
        Call localVarCall = this.createProjectInputValidateBeforeCall(workspaceId, projectId, type, id, description, _file, null);
        Type localVarReturnType = new TypeToken<CreateProjectInput201Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createProjectInputAsync(String workspaceId, String projectId, String type, String id, String description, File _file, ApiCallback<CreateProjectInput201Response> _callback) throws ApiException {
        Call localVarCall = this.createProjectInputValidateBeforeCall(workspaceId, projectId, type, id, description, _file, _callback);
        Type localVarReturnType = new TypeToken<CreateProjectInput201Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteProjectInputCall(String workspaceId, String projectId, String inputId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workspaces/{workspace-id}/projects/{project-id}/inputs/{input-id}".replace("{workspace-id}", this.localVarApiClient.escapeString(workspaceId.toString())).replace("{project-id}", this.localVarApiClient.escapeString(projectId.toString())).replace("{input-id}", this.localVarApiClient.escapeString(inputId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProjectInputValidateBeforeCall(String workspaceId, String projectId, String inputId, ApiCallback _callback) throws ApiException {
        if (workspaceId == null) {
            throw new ApiException("Missing the required parameter 'workspaceId' when calling deleteProjectInput(Async)");
        }
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling deleteProjectInput(Async)");
        }
        if (inputId == null) {
            throw new ApiException("Missing the required parameter 'inputId' when calling deleteProjectInput(Async)");
        }
        return this.deleteProjectInputCall(workspaceId, projectId, inputId, _callback);
    }

    public void deleteProjectInput(String workspaceId, String projectId, String inputId) throws ApiException {
        this.deleteProjectInputWithHttpInfo(workspaceId, projectId, inputId);
    }

    public ApiResponse<Void> deleteProjectInputWithHttpInfo(String workspaceId, String projectId, String inputId) throws ApiException {
        Call localVarCall = this.deleteProjectInputValidateBeforeCall(workspaceId, projectId, inputId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteProjectInputAsync(String workspaceId, String projectId, String inputId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteProjectInputValidateBeforeCall(workspaceId, projectId, inputId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getProjectInputCall(String workspaceId, String projectId, String inputId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workspaces/{workspace-id}/projects/{project-id}/inputs/{input-id}".replace("{workspace-id}", this.localVarApiClient.escapeString(workspaceId.toString())).replace("{project-id}", this.localVarApiClient.escapeString(projectId.toString())).replace("{input-id}", this.localVarApiClient.escapeString(inputId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProjectInputValidateBeforeCall(String workspaceId, String projectId, String inputId, ApiCallback _callback) throws ApiException {
        if (workspaceId == null) {
            throw new ApiException("Missing the required parameter 'workspaceId' when calling getProjectInput(Async)");
        }
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getProjectInput(Async)");
        }
        if (inputId == null) {
            throw new ApiException("Missing the required parameter 'inputId' when calling getProjectInput(Async)");
        }
        return this.getProjectInputCall(workspaceId, projectId, inputId, _callback);
    }

    public File getProjectInput(String workspaceId, String projectId, String inputId) throws ApiException {
        ApiResponse<File> localVarResp = this.getProjectInputWithHttpInfo(workspaceId, projectId, inputId);
        return localVarResp.getData();
    }

    public ApiResponse<File> getProjectInputWithHttpInfo(String workspaceId, String projectId, String inputId) throws ApiException {
        Call localVarCall = this.getProjectInputValidateBeforeCall(workspaceId, projectId, inputId, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProjectInputAsync(String workspaceId, String projectId, String inputId, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getProjectInputValidateBeforeCall(workspaceId, projectId, inputId, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

