/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.prebuilt.migrationtoolkit;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Iterator;
import java.util.Scanner;

public class MTAAnalysisReport {
    public static AnalysisIncidents extractIncidents(String jsIssuesData) throws Exception {
        Scanner scanner = new Scanner(jsIssuesData);
        while (scanner.hasNextLine()) {
            String s = scanner.nextLine();
            if (!s.startsWith("WINDUP_ISSUE_SUMMARIES[")) continue;
            s = s.replaceFirst("WINDUP_ISSUE_SUMMARIES\\[.*\\] =", "");
            ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
            try {
                int mandatory = 0;
                int optional = 0;
                int potential = 0;
                int cloudMandatory = 0;
                int cloudOptional = 0;
                int information = 0;
                JsonNode jsonNode = mapper.readTree(s);
                Iterator<String> it = jsonNode.fieldNames();
                while (it.hasNext()) {
                    String severity;
                    switch (severity = it.next()) {
                        case "mandatory": {
                            mandatory = jsonNode.get(severity).size();
                            break;
                        }
                        case "optional": {
                            optional = jsonNode.get(severity).size();
                            break;
                        }
                        case "potential": {
                            potential = jsonNode.get(severity).size();
                            break;
                        }
                        case "cloud-mandatory": {
                            cloudMandatory = jsonNode.get(severity).size();
                            break;
                        }
                        case "cloud-optional": {
                            cloudOptional = jsonNode.get(severity).size();
                            break;
                        }
                        case "information": {
                            information = jsonNode.get(severity).size();
                        }
                    }
                }
                return new AnalysisIncidents(mandatory, optional, potential, cloudMandatory, cloudOptional, information);
            }
            catch (JsonProcessingException e) {
                throw new Exception("failed extracting the incidents summary from issue_summaries.js " + e);
            }
        }
        throw new Exception("failed extracting the incidents summary from issue_summaries.js - didn't match any line. Possibly the format changedby MTA or wrong page is scanned. Data parsed: " + jsIssuesData);
    }

    public record AnalysisIncidents(int mandatory, int optional, int potential, int cloudMandatory, int cloudOptional, int information) {
    }
}

