/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.ocponboarding.task;

import com.redhat.parodos.examples.ocponboarding.task.dto.email.MessageRequestDTO;
import com.redhat.parodos.examples.utils.RestUtils;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.enums.WorkFlowTaskOutput;
import com.redhat.parodos.workflow.task.infrastructure.BaseInfrastructureWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;

public class AppLinkEmailNotificationWorkFlowTask
extends BaseInfrastructureWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppLinkEmailNotificationWorkFlowTask.class);
    private static final String TEMPLATE_DEFAULT_ENCODING = "UTF-8";
    private static final String TEMPLATE_BASE_PACKAGE_PATH = "templates";
    private static final String TEMPLATE_NAME = "appLinkEmailNotification.ftlh";
    private static final String APP_LINK_PARAMETER_NAME = "APP_LINK";
    private final String mailServiceUrl;
    private final String mailServiceSiteName;

    public AppLinkEmailNotificationWorkFlowTask(String mailServiceUrl, String mailServiceSiteName) {
        this.mailServiceUrl = mailServiceUrl;
        this.mailServiceSiteName = mailServiceSiteName;
    }

    public WorkReport execute(WorkContext workContext) {
        log.info("Start appLinkEmailNotificationWorkFlowTask...");
        String requesterName = "Test Test";
        String requesterEmail = "ttest@test.com";
        HashMap<String, Object> messageData = new HashMap<String, Object>();
        try {
            String appLink = this.getRequiredParameterValue(APP_LINK_PARAMETER_NAME);
            messageData.put("appLink", appLink);
            log.info("App link is: {}", (Object)appLink);
        }
        catch (MissingParameterException e) {
            log.error("AppLinkEmailNotificationWorkFlowTask failed! Message: {}", (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext);
        }
        ResponseEntity<String> responseEntity = null;
        try {
            String message = this.getMessage(TEMPLATE_NAME, messageData);
            if (message.isEmpty()) {
                log.info("AppLinkEmailNotificationWorkFlowTask failed due to empty message template!");
                return new DefaultWorkReport(WorkStatus.FAILED, workContext);
            }
            MessageRequestDTO messageRequestDTO = MessageRequestDTO.builder().name(requesterName).email(requesterEmail).siteName(this.mailServiceSiteName).message(message).build();
            HttpEntity requestEntity = new HttpEntity((Object)messageRequestDTO);
            responseEntity = RestUtils.executePost(this.mailServiceUrl, requestEntity);
        }
        catch (Exception e) {
            log.error("Error occurred when preparing or submitting the message: {}", (Object)e.getMessage());
        }
        if (!Objects.isNull(responseEntity) && responseEntity.getStatusCode().is2xxSuccessful() && !Objects.isNull(responseEntity.getBody()) && ((String)responseEntity.getBody()).contains("Mail Sent")) {
            log.info("AppLinkEmailNotificationWorkFlowTask completed!");
            return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
        }
        log.info("AppLinkEmailNotificationWorkFlowTask failed!");
        return new DefaultWorkReport(WorkStatus.FAILED, workContext);
    }

    public List<WorkFlowTaskOutput> getWorkFlowTaskOutputs() {
        return List.of(WorkFlowTaskOutput.EXCEPTION, WorkFlowTaskOutput.OTHER);
    }

    private String getMessage(String templateName, Map<String, Object> templateData) throws IOException, TemplateException {
        String message = "";
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_30);
        cfg.setClassLoaderForTemplateLoading(((Object)((Object)this)).getClass().getClassLoader(), TEMPLATE_BASE_PACKAGE_PATH);
        cfg.setDefaultEncoding(TEMPLATE_DEFAULT_ENCODING);
        Template template = cfg.getTemplate(templateName);
        try (StringWriter out = new StringWriter();){
            template.process(templateData, out);
            message = out.getBuffer().toString();
            out.flush();
        }
        return message;
    }
}

