/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.ocponboarding;

import com.redhat.parodos.examples.ocponboarding.checker.JiraTicketApprovalWorkFlowCheckerTask;
import com.redhat.parodos.examples.ocponboarding.escalation.JiraTicketApprovalEscalationWorkFlowTask;
import com.redhat.parodos.examples.ocponboarding.task.AppLinkEmailNotificationWorkFlowTask;
import com.redhat.parodos.examples.ocponboarding.task.JiraTicketCreationWorkFlowTask;
import com.redhat.parodos.examples.ocponboarding.task.JiraTicketEmailNotificationWorkFlowTask;
import com.redhat.parodos.examples.ocponboarding.task.NotificationWorkFlowTask;
import com.redhat.parodos.examples.ocponboarding.task.OcpAppDeploymentWorkFlowTask;
import com.redhat.parodos.examples.ocponboarding.task.assessment.OnboardingOcpAssessmentTask;
import com.redhat.parodos.workflow.annotation.Assessment;
import com.redhat.parodos.workflow.annotation.Checker;
import com.redhat.parodos.workflow.annotation.Escalation;
import com.redhat.parodos.workflow.annotation.Infrastructure;
import com.redhat.parodos.workflow.annotation.Parameter;
import com.redhat.parodos.workflow.option.WorkFlowOption;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.workflow.SequentialFlow;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"local"})
public class OcpOnboardingWorkFlowConfiguration {
    @Bean
    WorkFlowOption onboardingOcpOption() {
        return new WorkFlowOption.Builder("ocpOnboarding", "ocpOnboardingWorkFlow").addToDetails("this is for the app to deploy on OCP").displayName("Onboarding to OCP").setDescription("this is for the app to deploy on OCP").build();
    }

    @Bean
    WorkFlowOption move2kube() {
        return new WorkFlowOption.Builder("move2kube", "move2KubeWorkFlow_INFRASTRUCTURE_WORKFLOW").addToDetails("Transform the application into a Kubernetes application.").displayName("move2kube").setDescription("Transform application using move2kube").build();
    }

    @Bean
    WorkFlowOption badRepoOption() {
        return new WorkFlowOption.Builder("badRepoOption", "simpleSequentialWorkFlow_INFRASTRUCTURE_WORKFLOW").addToDetails("Container Fundamentals Training Required").displayName("Training Required").setDescription("Container Fundamentals Training Required").build();
    }

    @Bean
    WorkFlowOption notSupportOption() {
        return new WorkFlowOption.Builder("notSupportOption", "simpleSequentialWorkFlow_INFRASTRUCTURE_WORKFLOW").addToDetails("Non-Supported Workflow Steps").displayName("Not Supported").setDescription("Non-Supported Workflow Steps").build();
    }

    @Bean
    WorkFlowOption analyzeOption() {
        return new WorkFlowOption.Builder("analyzeOption", "AnalyzeApplicationAssessment").addToDetails("Analyze an application's source code before migrating it. Produces a containerization report by MTA").displayName("Migration Analysis").setDescription("Migration Analysis step").build();
    }

    @Bean
    OnboardingOcpAssessmentTask onboardingAssessmentTask(@Qualifier(value="onboardingOcpOption") WorkFlowOption onboardingOcpOption, @Qualifier(value="badRepoOption") WorkFlowOption badRepoOption, @Qualifier(value="notSupportOption") WorkFlowOption notSupportOption, @Qualifier(value="move2kube") WorkFlowOption move2kube, @Qualifier(value="analyzeOption") WorkFlowOption analyzeOption) {
        return new OnboardingOcpAssessmentTask(List.of(onboardingOcpOption, badRepoOption, notSupportOption, move2kube, analyzeOption));
    }

    @Bean(name={"onboardingAssessment_ASSESSMENT_WORKFLOW"})
    @Assessment
    WorkFlow assessmentWorkFlow(@Qualifier(value="onboardingAssessmentTask") OnboardingOcpAssessmentTask onboardingAssessmentTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("onboardingAssessment_ASSESSMENT_WORKFLOW").execute((Work)onboardingAssessmentTask).build();
    }

    @Bean
    JiraTicketApprovalEscalationWorkFlowTask jiraTicketApprovalEscalationWorkFlowTask(@Value(value="${MAIL_SERVICE_URL:service}") String mailServiceUrl, @Value(value="${MAIL_SERVICE_SITE_NAME_ESCALATION:site}") String mailServiceSiteName) {
        return new JiraTicketApprovalEscalationWorkFlowTask(mailServiceUrl, mailServiceSiteName);
    }

    @Bean(name={"jiraTicketApprovalEscalationWorkFlow"})
    @Escalation
    WorkFlow jiraTicketApprovalEscalationWorkFlow(@Qualifier(value="jiraTicketApprovalEscalationWorkFlowTask") JiraTicketApprovalEscalationWorkFlowTask jiraTicketApprovalEscalationWorkFlowTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("jiraTicketApprovalEscalationWorkFlow").execute((Work)jiraTicketApprovalEscalationWorkFlowTask).build();
    }

    @Bean
    JiraTicketApprovalWorkFlowCheckerTask jiraTicketApprovalWorkFlowCheckerTask(@Qualifier(value="jiraTicketApprovalEscalationWorkFlow") WorkFlow jiraTicketApprovalEscalationWorkFlow, @Value(value="${JIRA_URL:test}") String url, @Value(value="${JIRA_USER:user}") String username, @Value(value="${JIRA_TOKEN:token}") String password) {
        return new JiraTicketApprovalWorkFlowCheckerTask(jiraTicketApprovalEscalationWorkFlow, new Date().getTime() / 1000L + 30L, url, username, password);
    }

    @Bean(name={"jiraTicketApprovalWorkFlowChecker"})
    @Checker(cronExpression="*/5 * * * * ?")
    WorkFlow jiraTicketApprovalWorkFlowChecker(@Qualifier(value="jiraTicketApprovalWorkFlowCheckerTask") JiraTicketApprovalWorkFlowCheckerTask jiraTicketApprovalWorkFlowCheckerTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("jiraTicketApprovalWorkFlowChecker").execute((Work)jiraTicketApprovalWorkFlowCheckerTask).build();
    }

    @Bean
    JiraTicketCreationWorkFlowTask jiraTicketCreationWorkFlowTask(@Qualifier(value="jiraTicketApprovalWorkFlowChecker") WorkFlow jiraTicketApprovalWorkFlowChecker, @Value(value="${JIRA_URL:test}") String url, @Value(value="${JIRA_USER:user}") String username, @Value(value="${JIRA_TOKEN:token}") String password, @Value(value="${JIRA_APPROVER:approver}") String approverId) {
        JiraTicketCreationWorkFlowTask jiraTicketCreationWorkFlowTask = new JiraTicketCreationWorkFlowTask(url, username, password, approverId);
        jiraTicketCreationWorkFlowTask.setWorkFlowCheckers(List.of(jiraTicketApprovalWorkFlowChecker));
        return jiraTicketCreationWorkFlowTask;
    }

    @Bean
    JiraTicketEmailNotificationWorkFlowTask jiraTicketEmailNotificationWorkFlowTask(@Value(value="${MAIL_SERVICE_URL:service}") String mailServiceUrl, @Value(value="${MAIL_SERVICE_SITE_NAME_JIRA:site}") String mailServiceSiteName) {
        return new JiraTicketEmailNotificationWorkFlowTask(mailServiceUrl, mailServiceSiteName);
    }

    @Bean(name={"workFlowA"})
    @Infrastructure
    WorkFlow workFlowA(@Qualifier(value="jiraTicketCreationWorkFlowTask") JiraTicketCreationWorkFlowTask jiraTicketCreationWorkFlowTask, @Qualifier(value="jiraTicketEmailNotificationWorkFlowTask") JiraTicketEmailNotificationWorkFlowTask jiraTicketEmailNotificationWorkFlowTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("workFlowA").execute((Work)jiraTicketCreationWorkFlowTask).then((Work)jiraTicketEmailNotificationWorkFlowTask).build();
    }

    @Bean
    OcpAppDeploymentWorkFlowTask ocpAppDeploymentWorkFlowTask(@Value(value="${CLUSTER_API_URL:cluster}") String clusterApiUrl) {
        return new OcpAppDeploymentWorkFlowTask(clusterApiUrl);
    }

    @Bean
    NotificationWorkFlowTask notificationWorkFlowTask(@Value(value="${NOTIFICATION_SERVER_URL:test}") String notificationServiceUrl) {
        return new NotificationWorkFlowTask(notificationServiceUrl);
    }

    @Bean
    AppLinkEmailNotificationWorkFlowTask appLinkEmailNotificationWorkFlowTask(@Value(value="${MAIL_SERVICE_URL:service}") String mailServiceUrl, @Value(value="${MAIL_SERVICE_SITE_NAME_APP:site}") String mailServiceSiteName) {
        return new AppLinkEmailNotificationWorkFlowTask(mailServiceUrl, mailServiceSiteName);
    }

    @Bean(name={"workFlowB"})
    @Infrastructure
    WorkFlow workFlowB(@Qualifier(value="ocpAppDeploymentWorkFlowTask") OcpAppDeploymentWorkFlowTask ocpAppDeploymentWorkFlowTask, @Qualifier(value="notificationWorkFlowTask") NotificationWorkFlowTask notificationWorkFlowTask, @Qualifier(value="appLinkEmailNotificationWorkFlowTask") AppLinkEmailNotificationWorkFlowTask appLinkEmailNotificationWorkFlowTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("workFlowB").execute((Work)ocpAppDeploymentWorkFlowTask).then((Work)notificationWorkFlowTask).then((Work)appLinkEmailNotificationWorkFlowTask).build();
    }

    @Bean(name={"ocpOnboardingWorkFlow"})
    @Infrastructure(parameters={@Parameter(key="NAMESPACE", description="The namespace in the ocp cluster", type=WorkParameterType.TEXT, optional=false)})
    WorkFlow ocpOnboardingWorkFlow(@Qualifier(value="workFlowA") WorkFlow workFlowA, @Qualifier(value="workFlowB") WorkFlow workFlowB) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("ocpOnboardingWorkFlow").execute((Work)workFlowA).then((Work)workFlowB).build();
    }
}

