/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.move2kube.checker;

import com.google.common.base.Strings;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.task.checker.BaseWorkFlowCheckerTask;
import com.redhat.parodos.workflow.task.enums.WorkFlowTaskOutput;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import dev.parodos.move2kube.ApiClient;
import dev.parodos.move2kube.ApiException;
import dev.parodos.move2kube.api.ProjectsApi;
import dev.parodos.move2kube.client.model.Project;
import dev.parodos.move2kube.client.model.ProjectOutputsValue;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformChecker
extends BaseWorkFlowCheckerTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransformChecker.class);
    private ApiClient client = new ApiClient();
    private static String transformContextKey = "move2KubeTransformID";
    private static String workspaceContextKey = "move2KubeWorkspaceID";
    protected static String projectContextKey = "move2KubeProjectID";

    public TransformChecker(String server) {
        this.client.setBasePath(server);
    }

    public WorkReport checkWorkFlowStatus(WorkContext workContext) {
        String workspaceID = (String)workContext.get(workspaceContextKey);
        String projectID = (String)workContext.get(projectContextKey);
        String transformID = (String)workContext.get(transformContextKey);
        if (Strings.isNullOrEmpty((String)transformID)) {
            return new DefaultWorkReport(WorkStatus.PENDING, workContext, (Throwable)new IllegalArgumentException("There is no transform ID"));
        }
        ProjectsApi project = new ProjectsApi(this.client);
        try {
            Project res = project.getProject(workspaceID, projectID);
            ProjectOutputsValue output = Objects.requireNonNull(res.getOutputs()).get(transformID);
            if (output == null) {
                return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new IllegalArgumentException("Cannot get the project transformation output from the list"));
            }
            if (!Objects.equals(output.getStatus(), "done")) {
                return new DefaultWorkReport(WorkStatus.FAILED, workContext);
            }
        }
        catch (ApiException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new IllegalArgumentException("Cannot get current project for the workflow, error:" + e.getMessage()));
        }
        catch (Exception e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new IllegalArgumentException("Transform checker cannot be validated:" + e.getMessage()));
        }
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    public List<WorkParameter> getWorkFlowTaskParameters() {
        return Collections.emptyList();
    }

    public List<WorkFlowTaskOutput> getWorkFlowTaskOutputs() {
        return Collections.emptyList();
    }

    @Generated
    public static String getProjectContextKey() {
        return projectContextKey;
    }
}

