/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.simple.task;

import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflow.task.enums.WorkFlowTaskOutput;
import com.redhat.parodos.workflow.task.infrastructure.BaseInfrastructureWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LoggingWorkFlowTask
extends BaseInfrastructureWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggingWorkFlowTask.class);

    public WorkReport execute(WorkContext workContext) {
        log.info("Writing a message to the logs from: {}", (Object)this.getName());
        try {
            String userId = this.getRequiredParameterValue(workContext, "user-id");
            String apiServer = this.getRequiredParameterValue(workContext, "api-server");
            log.info("task parameter 'api-server' value in {} is {}", (Object)this.getName(), (Object)apiServer);
            log.info("workflow parameter 'user-id' value in {} is {}", (Object)this.getName(), (Object)userId);
            return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
        }
        catch (Exception e) {
            log.error("There was an issue with the task {}: {}", (Object)this.getName(), (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext);
        }
    }

    public List<WorkParameter> getWorkFlowTaskParameters() {
        return List.of(WorkParameter.builder().key("api-server").description("The api server").type(WorkParameterType.URL).optional(false).build(), WorkParameter.builder().key("user-id").description("The user id").type(WorkParameterType.TEXT).optional(false).jsonSchemaOptions(Map.of("minLength", "1", "maxLength", "64")).build());
    }

    public List<WorkFlowTaskOutput> getWorkFlowTaskOutputs() {
        return List.of(WorkFlowTaskOutput.OTHER);
    }
}

