/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.prebuilt.migrationtoolkit;

import com.redhat.parodos.email.Message;
import com.redhat.parodos.tasks.migrationtoolkit.CreateApplicationTask;
import com.redhat.parodos.tasks.migrationtoolkit.GetAnalysisTask;
import com.redhat.parodos.tasks.migrationtoolkit.GetApplicationTask;
import com.redhat.parodos.tasks.migrationtoolkit.SubmitAnalysisTask;
import com.redhat.parodos.workflow.annotation.Checker;
import com.redhat.parodos.workflow.annotation.Infrastructure;
import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.workflow.SequentialFlow;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Profile(value={"examples"})
@Configuration
public class MigrationAnalysisWorkflow {
    private String mtaUrl = Objects.requireNonNull(System.getenv("MTA_URL"));
    private final String mailerHost = Objects.requireNonNull(System.getenv("MAILER_HOST"));
    private final String mailerPort = Objects.requireNonNull(System.getenv("MAILER_PORT"));
    private final String mailerUser = Objects.requireNonNull(System.getenv("MAILER_USER"));
    private final String mailerPass = Objects.requireNonNull(System.getenv("MAILER_PASS"));

    @Bean
    public CreateApplicationTask createApplicationTask() {
        return new CreateApplicationTask(URI.create(this.mtaUrl), "");
    }

    @Bean
    public GetApplicationTask getApplicationTask() {
        return new GetApplicationTask(URI.create(this.mtaUrl), "");
    }

    @Bean
    public SubmitAnalysisTask submitAnalysisTask(WorkFlow fetchReportURL) {
        SubmitAnalysisTask t = new SubmitAnalysisTask(URI.create(this.mtaUrl), "");
        t.setWorkFlowCheckers(List.of(fetchReportURL));
        return t;
    }

    @Bean
    public GetAnalysisTask getAnalysisTask() {
        return new GetAnalysisTask(URI.create(this.mtaUrl), "", this.messageConsumer());
    }

    @Bean(name={"AnalyzeApplication"})
    @Infrastructure
    public WorkFlow AnalyzeApplication(CreateApplicationTask createApplicationTask, GetApplicationTask getAppTask, SubmitAnalysisTask submitAnalysisTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("AnalyzeApplication").execute((Work)createApplicationTask).then((Work)getAppTask).then((Work)submitAnalysisTask).build();
    }

    @Bean(value={"fetchReportURL"})
    @Checker(cronExpression="*/5 * * * * ?")
    public WorkFlow fetchReportURL(GetAnalysisTask getAnalysisTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("fetchReportURL").execute((Work)getAnalysisTask).build();
    }

    private Consumer<Message> messageConsumer() {
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setHost(this.mailerHost);
        sender.setPort(Integer.valueOf(this.mailerPort).intValue());
        sender.setUsername(this.mailerUser);
        sender.setPassword(this.mailerPass);
        Consumer<Message> messageConsumer = m -> {
            SimpleMailMessage message = new SimpleMailMessage();
            message.setTo(m.to());
            message.setFrom(m.from());
            message.setSubject(m.subject());
            message.setText(m.data());
            try {
                sender.send(message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        return messageConsumer;
    }
}

