/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.prebuilt;

import com.redhat.parodos.tasks.notification.NotificationWorkFlowTask;
import com.redhat.parodos.workflow.annotation.Infrastructure;
import com.redhat.parodos.workflow.utils.CredUtils;
import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.workflow.SequentialFlow;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PrebuiltWorkFlowConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrebuiltWorkFlowConfiguration.class);

    @Bean
    NotificationWorkFlowTask notificationTask() {
        String serverIp = Optional.ofNullable(System.getenv("NOTIFICATION_SERVER_ADDRESS")).orElse("localhost");
        String serverPort = Optional.ofNullable(System.getenv("NOTIFICATION_SERVER_PORT")).orElse("8080");
        String notificationWorkFlowBasePath = "http://" + serverIp + ":" + serverPort;
        log.info("NotificationWorkFlowTask basePath: {}", (Object)notificationWorkFlowBasePath);
        return new NotificationWorkFlowTask(notificationWorkFlowBasePath, "Basic " + CredUtils.getBase64Creds((String)"test", (String)"test"));
    }

    @Bean(name={"prebuiltWorkFlow_INFRASTRUCTURE_WORKFLOW"})
    @Infrastructure
    WorkFlow prebuiltSequentialWorkFlow(@Qualifier(value="notificationTask") NotificationWorkFlowTask notificationTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("prebuiltWorkFlow_INFRASTRUCTURE_WORKFLOW").execute((Work)notificationTask).build();
    }
}

