/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.complex;

import com.redhat.parodos.examples.complex.checker.MockApprovalWorkFlowCheckerTask;
import com.redhat.parodos.examples.complex.task.OnboardingAssessmentTask;
import com.redhat.parodos.examples.simple.task.LoggingWorkFlowTask;
import com.redhat.parodos.workflow.annotation.Assessment;
import com.redhat.parodos.workflow.annotation.Checker;
import com.redhat.parodos.workflow.annotation.Infrastructure;
import com.redhat.parodos.workflow.option.WorkFlowOption;
import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.workflow.ParallelFlow;
import com.redhat.parodos.workflows.workflow.SequentialFlow;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ComplexWorkFlowConfiguration {
    @Bean
    WorkFlowOption onboardingOption() {
        return new WorkFlowOption.Builder("onboardingOption", "onboardingWorkFlow_INFRASTRUCTURE_WORKFLOW").addToDetails("An example of a complex WorkFlow with Status checks").displayName("Onboarding").setDescription("An example of a complex WorkFlow").build();
    }

    @Bean
    OnboardingAssessmentTask onboardingAssessmentTask(@Qualifier(value="onboardingOption") WorkFlowOption awesomeToolsOption) {
        return new OnboardingAssessmentTask(awesomeToolsOption);
    }

    @Bean(name={"onboardingAssessment_ASSESSMENT_WORKFLOW"})
    @Assessment
    WorkFlow assessmentWorkFlow(@Qualifier(value="onboardingAssessmentTask") OnboardingAssessmentTask onboardingAssessmentTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("onboardingAssessment_ASSESSMENT_WORKFLOW").execute((Work)onboardingAssessmentTask).build();
    }

    @Bean
    LoggingWorkFlowTask certWorkFlowTask(@Qualifier(value="namespaceWorkFlow_CHECKER_WORKFLOW") WorkFlow namespaceWorkFlowCheckerWorkFlow) {
        LoggingWorkFlowTask loggingWorkFlow = new LoggingWorkFlowTask();
        loggingWorkFlow.setWorkFlowChecker(namespaceWorkFlowCheckerWorkFlow);
        return loggingWorkFlow;
    }

    @Bean
    LoggingWorkFlowTask adGroupWorkFlowTask(@Qualifier(value="onboardingWorkFlow_CHECKER_WORKFLOW") WorkFlow onboardingWorkFlowCheckerWorkFlow) {
        LoggingWorkFlowTask loggingWorkFlow = new LoggingWorkFlowTask();
        loggingWorkFlow.setWorkFlowChecker(onboardingWorkFlowCheckerWorkFlow);
        return loggingWorkFlow;
    }

    @Bean
    LoggingWorkFlowTask dynatraceWorkFlowTask(@Qualifier(value="onboardingWorkFlow_CHECKER_WORKFLOW") WorkFlow onboardingWorkFlowCheckerWorkFlow) {
        LoggingWorkFlowTask loggingWorkFlow = new LoggingWorkFlowTask();
        loggingWorkFlow.setWorkFlowChecker(onboardingWorkFlowCheckerWorkFlow);
        return loggingWorkFlow;
    }

    @Bean(name={"onboardingWorkFlow_INFRASTRUCTURE_WORKFLOW"})
    @Infrastructure
    WorkFlow onboardingWorkflow(@Qualifier(value="certWorkFlowTask") LoggingWorkFlowTask certWorkFlowTask, @Qualifier(value="adGroupWorkFlowTask") LoggingWorkFlowTask adGroupWorkFlowTask, @Qualifier(value="dynatraceWorkFlowTask") LoggingWorkFlowTask dynatraceWorkFlowTask) {
        return ParallelFlow.Builder.aNewParallelFlow().named("onboardingWorkFlow_INFRASTRUCTURE_WORKFLOW").execute(new Work[]{certWorkFlowTask, adGroupWorkFlowTask, dynatraceWorkFlowTask}).with(Executors.newFixedThreadPool(3)).build();
    }

    @Bean
    LoggingWorkFlowTask nameSpaceWorkFlowTask(@Qualifier(value="namespaceWorkFlow_CHECKER_WORKFLOW") WorkFlow namespaceWorkFlowCheckerWorkFlow) {
        LoggingWorkFlowTask loggingWorkFlow = new LoggingWorkFlowTask();
        loggingWorkFlow.setWorkFlowChecker(namespaceWorkFlowCheckerWorkFlow);
        return loggingWorkFlow;
    }

    @Bean(name={"nameSpaceWorkFlow_INFRASTRUCTURE_WORKFLOW"})
    @Infrastructure
    WorkFlow nameSpaceWorkFlow(@Qualifier(value="nameSpaceWorkFlowTask") LoggingWorkFlowTask nameSpaceWorkFlowTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("nameSpaceWorkFlow_INFRASTRUCTURE_WORKFLOW").execute((Work)nameSpaceWorkFlowTask).build();
    }

    @Bean
    LoggingWorkFlowTask loadBalancerFlowTask() {
        return new LoggingWorkFlowTask();
    }

    @Bean
    LoggingWorkFlowTask failOverWorkFlowTask() {
        return new LoggingWorkFlowTask();
    }

    @Bean(name={"networkingWorkFlow_INFRASTRUCTURE_WORKFLOW"})
    @Infrastructure
    WorkFlow networkingWorkFlow(@Qualifier(value="loadBalancerFlowTask") LoggingWorkFlowTask networkingFlowTask, @Qualifier(value="failOverWorkFlowTask") LoggingWorkFlowTask failOverWorkFlowTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("networkingWorkFlow_INFRASTRUCTURE_WORKFLOW").execute((Work)networkingFlowTask).then((Work)failOverWorkFlowTask).build();
    }

    @Bean
    MockApprovalWorkFlowCheckerTask approvalChecker() {
        return new MockApprovalWorkFlowCheckerTask();
    }

    @Bean(value={"onboardingWorkFlow_CHECKER_WORKFLOW"})
    @Checker(cronExpression="0/5 * * * * ?")
    WorkFlow onboardingWorkFlowCheckerWorkFlow(@Qualifier(value="approvalChecker") MockApprovalWorkFlowCheckerTask approvalChecker) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("onboardingWorkFlow_CHECKER_WORKFLOW").execute((Work)approvalChecker).build();
    }

    @Bean
    MockApprovalWorkFlowCheckerTask processCompletionChecker() {
        return new MockApprovalWorkFlowCheckerTask();
    }

    @Bean(value={"namespaceWorkFlow_CHECKER_WORKFLOW"})
    @Checker(cronExpression="0/5 * * * * ?")
    WorkFlow namespaceWorkFlowCheckerWorkFlow(@Qualifier(value="processCompletionChecker") MockApprovalWorkFlowCheckerTask processCompletionChecker) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("namespaceWorkFlow_CHECKER_WORKFLOW").execute((Work)processCompletionChecker).build();
    }
}

