/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflows.workflow;

import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

class ParallelFlowExecutor {
    private final ExecutorService workExecutor;

    ParallelFlowExecutor(ExecutorService workExecutor) {
        this.workExecutor = workExecutor;
    }

    List<WorkReport> executeInParallel(List<Work> workUnits, WorkContext workContext) {
        List futures;
        ArrayList tasks = new ArrayList(workUnits.size());
        workUnits.forEach(work -> {
            boolean bl = tasks.add(() -> work.execute(workContext));
        });
        try {
            futures = this.workExecutor.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("The parallel flow was interrupted while executing work units", e);
        }
        HashMap workToReportFuturesMap = new HashMap();
        int index = 0;
        while (index < workUnits.size()) {
            workToReportFuturesMap.put(workUnits.get(index), futures.get(index));
            ++index;
        }
        ArrayList<WorkReport> workReports = new ArrayList<WorkReport>();
        for (Map.Entry entry : workToReportFuturesMap.entrySet()) {
            try {
                workReports.add((WorkReport)((Future)entry.getValue()).get());
            }
            catch (InterruptedException e) {
                String message = String.format("The parallel flow was interrupted while waiting for the result of work unit '%s'", ((Work)entry.getKey()).getName());
                throw new RuntimeException(message, e);
            }
            catch (ExecutionException e) {
                String message = String.format("Unable to execute work unit '%s'", ((Work)entry.getKey()).getName());
                throw new RuntimeException(message, e);
            }
        }
        return workReports;
    }
}

