/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflows.workflow;

import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.workflow.AbstractWorkFlow;
import com.redhat.parodos.workflows.workflow.ParallelFlowExecutor;
import com.redhat.parodos.workflows.workflow.ParallelFlowReport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;

public class ParallelFlow
extends AbstractWorkFlow {
    private final List<Work> workUnits = new ArrayList<Work>();
    private final ParallelFlowExecutor workExecutor;

    ParallelFlow(String name, List<Work> workUnits, ParallelFlowExecutor parallelFlowExecutor) {
        super(name);
        this.workUnits.addAll(workUnits);
        this.workExecutor = parallelFlowExecutor;
    }

    @Override
    public ParallelFlowReport execute(WorkContext workContext) {
        ParallelFlowReport workFlowReport = new ParallelFlowReport();
        List<WorkReport> workReports = this.workExecutor.executeInParallel(this.workUnits, workContext);
        workFlowReport.addAll(workReports);
        return workFlowReport;
    }

    public static class Builder {
        private Builder() {
        }

        public static NameStep aNewParallelFlow() {
            return new BuildSteps();
        }

        public static interface BuildStep {
            public ParallelFlow build();
        }

        private static class BuildSteps
        implements NameStep,
        ExecuteStep,
        WithStep,
        BuildStep {
            private String name = UUID.randomUUID().toString();
            private final List<Work> works = new ArrayList<Work>();
            private ExecutorService executorService;

            @Override
            public ExecuteStep named(String name) {
                this.name = name;
                return this;
            }

            @Override
            public WithStep execute(Work ... workUnits) {
                this.works.addAll(Arrays.asList(workUnits));
                return this;
            }

            @Override
            public BuildStep with(ExecutorService executorService) {
                this.executorService = executorService;
                return this;
            }

            @Override
            public ParallelFlow build() {
                return new ParallelFlow(this.name, this.works, new ParallelFlowExecutor(this.executorService));
            }
        }

        public static interface ExecuteStep {
            public WithStep execute(Work ... var1);
        }

        public static interface NameStep
        extends ExecuteStep {
            public ExecuteStep named(String var1);
        }

        public static interface WithStep {
            public BuildStep with(ExecutorService var1);
        }
    }
}

