/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflows.workflow;

import com.redhat.parodos.workflows.work.NoOpWork;
import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkReportPredicate;
import com.redhat.parodos.workflows.workflow.AbstractWorkFlow;
import java.util.UUID;

public class ConditionalFlow
extends AbstractWorkFlow {
    private final Work initialWorkUnit;
    private final Work nextOnPredicateSuccess;
    private final Work nextOnPredicateFailure;
    private final WorkReportPredicate predicate;

    ConditionalFlow(String name, Work initialWorkUnit, Work nextOnPredicateSuccess, Work nextOnPredicateFailure, WorkReportPredicate predicate) {
        super(name);
        this.initialWorkUnit = initialWorkUnit;
        this.nextOnPredicateSuccess = nextOnPredicateSuccess;
        this.nextOnPredicateFailure = nextOnPredicateFailure;
        this.predicate = predicate;
    }

    @Override
    public WorkReport execute(WorkContext workContext) {
        WorkReport jobReport = this.initialWorkUnit.execute(workContext);
        if (this.predicate.apply(jobReport)) {
            jobReport = this.nextOnPredicateSuccess.execute(workContext);
        } else if (this.nextOnPredicateFailure != null && !(this.nextOnPredicateFailure instanceof NoOpWork)) {
            jobReport = this.nextOnPredicateFailure.execute(workContext);
        }
        return jobReport;
    }

    public static class Builder {
        private Builder() {
        }

        public static NameStep aNewConditionalFlow() {
            return new BuildSteps();
        }

        public static interface BuildStep {
            public ConditionalFlow build();
        }

        private static class BuildSteps
        implements NameStep,
        ExecuteStep,
        WhenStep,
        ThenStep,
        OtherwiseStep,
        BuildStep {
            private String name = UUID.randomUUID().toString();
            private Work initialWorkUnit = new NoOpWork();
            private Work nextOnPredicateSuccess = new NoOpWork();
            private Work nextOnPredicateFailure = new NoOpWork();
            private WorkReportPredicate predicate = WorkReportPredicate.ALWAYS_FALSE;

            BuildSteps() {
            }

            @Override
            public ExecuteStep named(String name) {
                this.name = name;
                return this;
            }

            @Override
            public WhenStep execute(Work initialWorkUnit) {
                this.initialWorkUnit = initialWorkUnit;
                return this;
            }

            @Override
            public ThenStep when(WorkReportPredicate predicate) {
                this.predicate = predicate;
                return this;
            }

            @Override
            public OtherwiseStep then(Work work) {
                this.nextOnPredicateSuccess = work;
                return this;
            }

            @Override
            public BuildStep otherwise(Work work) {
                this.nextOnPredicateFailure = work;
                return this;
            }

            @Override
            public ConditionalFlow build() {
                return new ConditionalFlow(this.name, this.initialWorkUnit, this.nextOnPredicateSuccess, this.nextOnPredicateFailure, this.predicate);
            }
        }

        public static interface ExecuteStep {
            public WhenStep execute(Work var1);
        }

        public static interface NameStep
        extends ExecuteStep {
            public ExecuteStep named(String var1);
        }

        public static interface OtherwiseStep
        extends BuildStep {
            public BuildStep otherwise(Work var1);
        }

        public static interface ThenStep {
            public OtherwiseStep then(Work var1);
        }

        public static interface WhenStep {
            public ThenStep when(WorkReportPredicate var1);
        }
    }
}

