/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflows.workflow;

import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import com.redhat.parodos.workflows.workflow.AbstractWorkFlow;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialFlow
extends AbstractWorkFlow {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SequentialFlow.class.getName());
    private final List<Work> workUnits = new ArrayList<Work>();

    SequentialFlow(String name, List<Work> workUnits) {
        super(name);
        this.workUnits.addAll(workUnits);
    }

    @Override
    public WorkReport execute(WorkContext workContext) {
        WorkReport workReport = null;
        for (Work work : this.workUnits) {
            workReport = work.execute(workContext);
            if (workReport != null && WorkStatus.COMPLETED == workReport.getStatus()) continue;
            if (workReport == null) {
                LOGGER.info("Work unit \"{}\" returned with empty WorkReport, skipping subsequent work units", (Object)work.getName());
                break;
            }
            LOGGER.info("Work unit \"{}\" returned with WorkStatus = \"{}\", skipping subsequent work units", (Object)work.getName(), (Object)workReport.getStatus());
            break;
        }
        return workReport;
    }

    public static class Builder {
        private Builder() {
        }

        public static NameStep aNewSequentialFlow() {
            return new BuildSteps();
        }

        private static class BuildSteps
        implements NameStep,
        ExecuteStep,
        ThenStep {
            private String name = UUID.randomUUID().toString();
            private final List<Work> works = new ArrayList<Work>();

            BuildSteps() {
            }

            @Override
            public ExecuteStep named(String name) {
                this.name = name;
                return this;
            }

            @Override
            public ThenStep execute(Work initialWork) {
                this.works.add(initialWork);
                return this;
            }

            @Override
            public ThenStep execute(List<Work> initialWorkUnits) {
                this.works.addAll(initialWorkUnits);
                return this;
            }

            @Override
            public ThenStep then(Work nextWork) {
                this.works.add(nextWork);
                return this;
            }

            @Override
            public ThenStep then(List<Work> nextWorkUnits) {
                this.works.addAll(nextWorkUnits);
                return this;
            }

            @Override
            public SequentialFlow build() {
                return new SequentialFlow(this.name, this.works);
            }
        }

        public static interface ThenStep {
            public ThenStep then(Work var1);

            public ThenStep then(List<Work> var1);

            public SequentialFlow build();
        }

        public static interface ExecuteStep {
            public ThenStep execute(Work var1);

            public ThenStep execute(List<Work> var1);
        }

        public static interface NameStep
        extends ExecuteStep {
            public ExecuteStep named(String var1);
        }
    }
}

