/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflows.work;

import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.util.concurrent.atomic.AtomicInteger;

@FunctionalInterface
public interface WorkReportPredicate {
    public static final WorkReportPredicate ALWAYS_TRUE = workReport -> true;
    public static final WorkReportPredicate ALWAYS_FALSE = workReport -> false;
    public static final WorkReportPredicate COMPLETED = workReport -> workReport.getStatus() == WorkStatus.COMPLETED;
    public static final WorkReportPredicate FAILED = workReport -> workReport.getStatus() == WorkStatus.FAILED;

    public boolean apply(WorkReport var1);

    public static class TimesPredicate
    implements WorkReportPredicate {
        private final int times;
        private final AtomicInteger counter = new AtomicInteger();

        public TimesPredicate(int times) {
            this.times = times;
        }

        @Override
        public boolean apply(WorkReport workReport) {
            return this.counter.incrementAndGet() != this.times;
        }

        public static TimesPredicate times(int times) {
            return new TimesPredicate(times);
        }
    }
}

