/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflows.workflow;

import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ParallelFlowReport
implements WorkReport {
    private final List<WorkReport> reports;

    public ParallelFlowReport() {
        this(new ArrayList<WorkReport>());
    }

    public ParallelFlowReport(List<WorkReport> reports) {
        this.reports = reports;
    }

    public List<WorkReport> getReports() {
        return this.reports;
    }

    void add(WorkReport workReport) {
        this.reports.add(workReport);
    }

    void addAll(List<WorkReport> workReports) {
        this.reports.addAll(workReports);
    }

    @Override
    public WorkStatus getStatus() {
        WorkStatus workStatus = WorkStatus.COMPLETED;
        block4: for (WorkReport report : this.reports) {
            switch (report.getStatus()) {
                case FAILED: 
                case REJECTED: {
                    return report.getStatus();
                }
                case COMPLETED: {
                    continue block4;
                }
            }
            workStatus = report.getStatus();
        }
        return workStatus;
    }

    @Override
    public Throwable getError() {
        for (WorkReport report : this.reports) {
            Throwable error = report.getError();
            if (error == null) continue;
            return error;
        }
        return null;
    }

    @Override
    public WorkContext getWorkContext() {
        WorkContext workContext = new WorkContext();
        for (WorkReport report : this.reports) {
            WorkContext partialContext = report.getWorkContext();
            for (Map.Entry<String, Object> entry : partialContext.getEntrySet()) {
                workContext.put(entry.getKey(), entry.getValue());
            }
        }
        return workContext;
    }
}

