/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.sdkutils;

import com.redhat.parodos.sdkutils.WorkFlowServiceUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RetryExecutorService<T>
implements AutoCloseable {
    private static final int MAX_RETRY_TIME = 240000;
    public static final int RETRY_DELAY = 5000;
    private final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();

    public T submitWithRetry(Callable<T> task) {
        return this.submitWithRetry(task, () -> {}, () -> {}, 240000L, 5000L);
    }

    public T submitWithRetry(Callable<T> task, long maxRetryTime) {
        return this.submitWithRetry(task, () -> {}, () -> {}, maxRetryTime, 5000L);
    }

    public T submitWithRetry(Callable<T> task, Runnable onSuccess, Runnable onFailure, long maxRetryTime, long retryDelay) {
        CompletableFuture future = new CompletableFuture();
        long startTime = System.currentTimeMillis();
        long endTime = startTime + maxRetryTime;
        ScheduledFuture<?> scheduledFuture = this.scheduledExecutor.scheduleWithFixedDelay(() -> {
            if (System.currentTimeMillis() >= endTime) {
                future.completeExceptionally(new TimeoutException("Retry limit reached."));
                return;
            }
            try {
                Object result = task.call();
                onSuccess.run();
                future.complete(result);
            }
            catch (WorkFlowServiceUtils.InProgressStatusException e) {
                return;
            }
            catch (Exception e) {
                onFailure.run();
                future.completeExceptionally(e);
                return;
            }
        }, 0L, retryDelay, TimeUnit.MILLISECONDS);
        try {
            Object t = future.get();
            return t;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            scheduledFuture.cancel(false);
            this.scheduledExecutor.shutdown();
        }
    }

    @Override
    public void close() throws Exception {
        boolean awaited = this.scheduledExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        if (!awaited) {
            throw new RuntimeException("Failed to await termination of executor service");
        }
    }
}

