/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.sdkutils;

import com.google.common.base.Strings;
import com.redhat.parodos.sdk.api.LoginApi;
import com.redhat.parodos.sdk.api.ProjectApi;
import com.redhat.parodos.sdk.api.WorkflowApi;
import com.redhat.parodos.sdk.invoker.ApiClient;
import com.redhat.parodos.sdk.invoker.ApiException;
import com.redhat.parodos.sdk.invoker.ApiResponse;
import com.redhat.parodos.sdk.invoker.Configuration;
import com.redhat.parodos.sdk.model.ProjectRequestDTO;
import com.redhat.parodos.sdk.model.ProjectResponseDTO;
import com.redhat.parodos.sdk.model.WorkFlowStatusResponseDTO;
import com.redhat.parodos.sdkutils.RetryExecutorService;
import com.redhat.parodos.workflow.utils.CredUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.MissingRequiredPropertiesException;

public abstract class WorkFlowServiceUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkFlowServiceUtils.class);

    private WorkFlowServiceUtils() {
    }

    public static ApiClient getParodosAPiClient() throws ApiException, MissingRequiredPropertiesException {
        ApiClient apiClient = Configuration.getDefaultApiClient();
        String serverIp = Optional.ofNullable(System.getenv("WORKFLOW_SERVICE_HOST")).orElse("localhost");
        String serverPort = Optional.ofNullable(System.getenv("SERVER_PORT")).orElse("8080");
        if (Strings.isNullOrEmpty((String)serverIp) || Strings.isNullOrEmpty((String)serverPort)) {
            throw new IllegalArgumentException("SERVER_IP and SERVER_PORT must be set");
        }
        int port = Integer.parseInt(serverPort);
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("serverPort must be > 0 && <= 65535");
        }
        String basePath = "http://%s:%s".formatted(serverIp, serverPort);
        log.info("serverIp is: {}, serverPort is {}. Set BasePath to {}", new Object[]{serverIp, serverPort, basePath});
        apiClient.setBasePath(basePath);
        apiClient.addDefaultHeader("Authorization", "Basic " + CredUtils.getBase64Creds((String)"test", (String)"test"));
        WorkFlowServiceUtils.waitProjectStart(new ProjectApi(apiClient));
        LoginApi loginApi = new LoginApi(apiClient);
        ApiResponse loginResponse = loginApi.loginWithHttpInfo();
        Map headers = loginResponse.getHeaders();
        List cookieHeaders = (List)headers.get("Set-Cookie");
        String xsrfToken = null;
        String JSessionID = null;
        if (cookieHeaders != null) {
            xsrfToken = WorkFlowServiceUtils.getCookieValue(cookieHeaders, "XSRF-TOKEN");
            JSessionID = WorkFlowServiceUtils.getCookieValue(cookieHeaders, "JSESSIONID");
        }
        log.debug("Found X-CSRF-TOKEN: {} and JSessionID: {}", (Object)xsrfToken, JSessionID);
        if (xsrfToken != null) {
            apiClient.addDefaultHeader("X-XSRF-TOKEN", xsrfToken);
            apiClient.addDefaultCookie("JSESSIONID", JSessionID);
            apiClient.addDefaultCookie("XSRF-TOKEN", xsrfToken);
        }
        return apiClient;
    }

    @Nullable
    private static String getCookieValue(List<String> cookieHeaders, String anObject) {
        String cookieHeader;
        String token = null;
        Iterator<String> iterator = cookieHeaders.iterator();
        while (iterator.hasNext() && (token = (String)Stream.of((cookieHeader = iterator.next()).split(";")).map(cookie -> cookie.trim().split("=")).filter(parts -> ((String[])parts).length == 2 && parts[0].equals(anObject)).findFirst().map(parts -> parts[1]).orElse(null)) == null) {
        }
        return token;
    }

    public static void waitProjectStart(ProjectApi projectApi) {
        try (RetryExecutorService<Void> executorService = new RetryExecutorService<Void>();){
            Callable<Void> task = () -> {
                projectApi.getProjects();
                return null;
            };
            executorService.submitWithRetry(task);
        }
        catch (Exception e) {
            throw new RuntimeException("Project API is not up and running", e);
        }
    }

    public static WorkFlowStatusResponseDTO waitWorkflowStatusAsync(WorkflowApi workflowApi, UUID workFlowExecutionId) {
        return WorkFlowServiceUtils.waitWorkflowStatusAsync(workflowApi, workFlowExecutionId, WorkFlowStatusResponseDTO.StatusEnum.COMPLETED);
    }

    public static WorkFlowStatusResponseDTO waitWorkflowStatusAsync(WorkflowApi workflowApi, UUID workFlowExecutionId, WorkFlowStatusResponseDTO.StatusEnum expectedStatus) {
        WorkFlowStatusResponseDTO result;
        try (RetryExecutorService<WorkFlowStatusResponseDTO> executorService = new RetryExecutorService<WorkFlowStatusResponseDTO>();){
            Callable<WorkFlowStatusResponseDTO> task = () -> {
                WorkFlowStatusResponseDTO status = workflowApi.getStatus(workFlowExecutionId);
                if (status.getStatus() != expectedStatus) {
                    throw new ApiException("Workflow status is not " + expectedStatus);
                }
                return status;
            };
            result = executorService.submitWithRetry(task);
        }
        catch (Exception e) {
            throw new RuntimeException("Workflow status is not " + expectedStatus, e);
        }
        return result;
    }

    @Nullable
    public static ProjectResponseDTO getProjectByNameAndDescription(List<ProjectResponseDTO> projects, String projectName, String projectDescription) {
        return projects.stream().filter(prj -> projectName.equals(prj.getName()) && projectDescription.equals(prj.getDescription()) && prj.getId() != null).findAny().orElse(null);
    }

    public static ProjectResponseDTO getProjectAsync(ApiClient apiClient, String projectName, String projectDescription) throws ApiException {
        ProjectApi projectApi = new ProjectApi(apiClient);
        log.info("Get all available projects");
        List projects = projectApi.getProjects();
        ProjectResponseDTO testProject = WorkFlowServiceUtils.getProjectByNameAndDescription(projects, projectName, projectDescription);
        if (testProject == null) {
            log.info("There are no projects. Creating project {}", (Object)projectName);
            ProjectRequestDTO projectRequestDTO = new ProjectRequestDTO();
            projectRequestDTO.setName(projectName);
            projectRequestDTO.setDescription(projectDescription);
            ProjectResponseDTO projectResponseDTO = projectApi.createProject(projectRequestDTO);
            if (projectResponseDTO == null || projectResponseDTO.getName() == null || projectResponseDTO.getDescription() == null) {
                throw new ApiException("Can't create new project");
            }
            if (!projectName.equals(projectResponseDTO.getName()) || !projectDescription.equals(projectResponseDTO.getDescription())) {
                throw new ApiException("Can't create project correctly. Requested project name and description are: " + projectName + "," + projectDescription + ". Actual are: " + projectResponseDTO.getName() + projectResponseDTO.getDescription());
            }
            log.info("Project {} successfully created", (Object)projectName);
        }
        if ((projects = projectApi.getProjects()).isEmpty()) {
            throw new ApiException("Project has not been created.");
        }
        testProject = WorkFlowServiceUtils.getProjectByNameAndDescription(projects, projectName, projectDescription);
        if (testProject == null) {
            throw new ApiException("Can retrieve project with name " + projectName);
        }
        return testProject;
    }
}

