/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.sdkutils;

import com.google.common.base.Strings;
import com.redhat.parodos.notification.sdk.api.ApiClient;
import com.redhat.parodos.notification.sdk.api.Configuration;
import com.redhat.parodos.notification.sdk.api.NotificationRecordApi;
import com.redhat.parodos.sdkutils.RetryExecutorService;
import com.redhat.parodos.workflow.utils.CredUtils;
import java.util.Optional;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.MissingRequiredPropertiesException;

public abstract class NotificationServiceUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationServiceUtils.class);

    private NotificationServiceUtils() {
    }

    public static ApiClient getParodosAPiClient() throws MissingRequiredPropertiesException {
        ApiClient apiClient = Configuration.getDefaultApiClient();
        String serverIp = Optional.ofNullable(System.getenv("NOTIFICATION_SERVICE_HOST")).orElse("localhost");
        String serverPort = Optional.ofNullable(System.getenv("SERVER_PORT")).orElse("8081");
        if (Strings.isNullOrEmpty((String)serverIp) || Strings.isNullOrEmpty((String)serverPort)) {
            throw new IllegalArgumentException("NOTIFICATION_SERVER_ADDRESS and NOTIFICATION_SERVER_PORT must be set");
        }
        int port = Integer.parseInt(serverPort);
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("serverPort must be > 0 && <= 65535");
        }
        String basePath = "http://%s:%s".formatted(serverIp, serverPort);
        log.info("serverIp is: {}, serverPort is {}. Set BasePath to {}", new Object[]{serverIp, serverPort, basePath});
        apiClient.setBasePath(basePath);
        apiClient.addDefaultHeader("Authorization", "Basic " + CredUtils.getBase64Creds((String)"test", (String)"test"));
        NotificationServiceUtils.waitNotificationStart(apiClient);
        return apiClient;
    }

    public static void waitNotificationStart(ApiClient apiclient) {
        NotificationRecordApi notificationRecordApi = new NotificationRecordApi(apiclient);
        try (RetryExecutorService<Void> executorService = new RetryExecutorService<Void>();){
            Callable<Void> task = () -> {
                notificationRecordApi.getNotifications(Integer.valueOf(0), Integer.valueOf(10), null, null, null);
                return null;
            };
            executorService.submitWithRetry(task);
        }
        catch (Exception e) {
            throw new RuntimeException("Notification Record API is not up and running", e);
        }
    }
}

