/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.sdkutils;

import com.google.common.base.Strings;
import com.redhat.parodos.sdk.api.LoginApi;
import com.redhat.parodos.sdk.api.ProjectApi;
import com.redhat.parodos.sdk.api.WorkflowApi;
import com.redhat.parodos.sdk.invoker.ApiCallback;
import com.redhat.parodos.sdk.invoker.ApiClient;
import com.redhat.parodos.sdk.invoker.ApiException;
import com.redhat.parodos.sdk.invoker.ApiResponse;
import com.redhat.parodos.sdk.invoker.Configuration;
import com.redhat.parodos.sdk.model.ProjectRequestDTO;
import com.redhat.parodos.sdk.model.ProjectResponseDTO;
import com.redhat.parodos.sdk.model.WorkFlowStatusResponseDTO;
import com.redhat.parodos.workflow.utils.CredUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.MissingRequiredPropertiesException;

public abstract class SdkUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SdkUtils.class);
    private static String serverIp = "localhost";

    private SdkUtils() {
    }

    public static ApiClient getParodosAPiClient() throws ApiException, MissingRequiredPropertiesException, InterruptedException {
        ApiClient apiClient = Configuration.getDefaultApiClient();
        serverIp = Optional.ofNullable(System.getenv("SERVER_IP")).orElse("localhost");
        String serverPort = Optional.ofNullable(System.getenv("SERVER_PORT")).orElse("8080");
        if (Strings.isNullOrEmpty((String)serverIp) || Strings.isNullOrEmpty((String)serverPort)) {
            throw new IllegalArgumentException("SERVER_IP and SERVER_PORT must be set");
        }
        int port = Integer.parseInt(serverPort);
        if (port <= 0 && port > 65535) {
            throw new IllegalArgumentException("serverPort must be > 0 && <= 65535");
        }
        String basePath = "http://" + serverIp + ":" + serverPort;
        log.info("serverIp is: {}, serverPort is {}. Set BasePath to {}", new Object[]{serverIp, serverPort, basePath});
        apiClient.setBasePath(basePath);
        apiClient.addDefaultHeader("Authorization", "Basic " + CredUtils.getBase64Creds((String)"test", (String)"test"));
        SdkUtils.waitProjectStart(new ProjectApi(apiClient));
        LoginApi loginApi = new LoginApi(apiClient);
        ApiResponse loginResponse = loginApi.loginWithHttpInfo();
        Map headers = loginResponse.getHeaders();
        List cookieHeaders = (List)headers.get("Set-Cookie");
        String xsrfToken = null;
        String JSessionID = null;
        if (cookieHeaders != null) {
            xsrfToken = SdkUtils.getCookieValue(cookieHeaders, "XSRF-TOKEN");
            JSessionID = SdkUtils.getCookieValue(cookieHeaders, "JSESSIONID");
        }
        log.debug("Found X-CSRF-TOKEN: {} and JSessionID: {}", (Object)xsrfToken, JSessionID);
        if (xsrfToken != null) {
            apiClient.addDefaultHeader("X-XSRF-TOKEN", xsrfToken);
            apiClient.addDefaultCookie("JSESSIONID", JSessionID);
            apiClient.addDefaultCookie("XSRF-TOKEN", xsrfToken);
        }
        return apiClient;
    }

    @Nullable
    private static String getCookieValue(List<String> cookieHeaders, String anObject) {
        String cookieHeader;
        String token = null;
        Iterator<String> iterator = cookieHeaders.iterator();
        while (iterator.hasNext() && (token = (String)Stream.of((cookieHeader = iterator.next()).split(";")).map(cookie -> cookie.trim().split("=")).filter(parts -> ((String[])parts).length == 2 && parts[0].equals(anObject)).findFirst().map(parts -> parts[1]).orElse(null)) == null) {
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T waitAsyncResponse(final FuncExecutor<T> f) throws ApiException, InterruptedException {
        final AsyncResult asyncResult = new AsyncResult();
        final ReentrantLock lock = new ReentrantLock();
        final Condition response = lock.newCondition();
        ApiCallback apiCallback = new ApiCallback<T>(){

            public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                log.info("onFailure {}", (Object)e.getMessage());
                try {
                    f.execute(this);
                }
                catch (ApiException apie) {
                    asyncResult.setError(apie.getMessage());
                    this.signal();
                }
            }

            public void onSuccess(T result, int statusCode, Map<String, List<String>> responseHeaders) {
                if (f.check(result, statusCode)) {
                    try {
                        f.execute(this);
                    }
                    catch (ApiException apie) {
                        asyncResult.setError(apie.getMessage());
                        this.signal();
                    }
                } else {
                    asyncResult.setStatusCode(statusCode);
                    asyncResult.setResult(result);
                    asyncResult.setError(null);
                    this.signal();
                }
            }

            public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
            }

            public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
            }

            private void signal() {
                lock.lock();
                try {
                    response.signal();
                }
                finally {
                    lock.unlock();
                }
            }
        };
        f.execute(apiCallback);
        lock.lock();
        try {
            response.await(60L, TimeUnit.SECONDS);
            if (asyncResult.getError() != null) {
                throw new ApiException("An error occurred while executing waitAsyncResponse: " + asyncResult.getError());
            }
        }
        finally {
            lock.unlock();
        }
        return asyncResult.getResult();
    }

    public static void waitProjectStart(final ProjectApi projectApi) throws ApiException, InterruptedException {
        SdkUtils.waitAsyncResponse(new FuncExecutor<List<ProjectResponseDTO>>(){

            @Override
            public boolean check(List<ProjectResponseDTO> result, int statusCode) {
                return statusCode != 200;
            }

            @Override
            public void execute(@NonNull ApiCallback<List<ProjectResponseDTO>> callback) throws ApiException {
                if (callback == null) {
                    throw new NullPointerException("callback is marked non-null but is null");
                }
                projectApi.getProjectsAsync(callback);
            }
        });
    }

    public static WorkFlowStatusResponseDTO waitWorkflowStatusAsync(WorkflowApi workflowApi, UUID workFlowExecutionId) throws InterruptedException, ApiException {
        return SdkUtils.waitWorkflowStatusAsync(workflowApi, workFlowExecutionId, WorkFlowStatusResponseDTO.StatusEnum.COMPLETED);
    }

    public static WorkFlowStatusResponseDTO waitWorkflowStatusAsync(final WorkflowApi workflowApi, final UUID workFlowExecutionId, final WorkFlowStatusResponseDTO.StatusEnum status) throws InterruptedException, ApiException {
        WorkFlowStatusResponseDTO workFlowStatusResponseDTO = SdkUtils.waitAsyncResponse(new FuncExecutor<WorkFlowStatusResponseDTO>(){

            @Override
            public boolean check(WorkFlowStatusResponseDTO result, int statusCode) {
                return result.getStatus() != status;
            }

            @Override
            public void execute(@NonNull ApiCallback<WorkFlowStatusResponseDTO> callback) throws ApiException {
                if (callback == null) {
                    throw new NullPointerException("callback is marked non-null but is null");
                }
                workflowApi.getStatusAsync(workFlowExecutionId, callback);
            }
        });
        return workFlowStatusResponseDTO;
    }

    @Nullable
    public static ProjectResponseDTO getProjectByNameAndDescription(List<ProjectResponseDTO> projects, String projectName, String projectDescription) {
        return projects.stream().filter(prj -> projectName.equals(prj.getName()) && projectDescription.equals(prj.getDescription()) && prj.getId() != null).findAny().orElse(null);
    }

    public static ProjectResponseDTO getProjectAsync(ApiClient apiClient, String projectName, String projectDescription) throws ApiException {
        ProjectApi projectApi = new ProjectApi(apiClient);
        log.info("Get all available projects");
        List projects = projectApi.getProjects();
        ProjectResponseDTO testProject = SdkUtils.getProjectByNameAndDescription(projects, projectName, projectDescription);
        if (testProject == null) {
            log.info("There are no projects. Creating project {}", (Object)projectName);
            ProjectRequestDTO projectRequestDTO = new ProjectRequestDTO();
            projectRequestDTO.setName(projectName);
            projectRequestDTO.setDescription(projectDescription);
            ProjectResponseDTO projectResponseDTO = projectApi.createProject(projectRequestDTO);
            if (projectResponseDTO == null || projectResponseDTO.getName() == null || projectResponseDTO.getDescription() == null) {
                throw new ApiException("Can't create new project");
            }
            if (!projectName.equals(projectResponseDTO.getName()) || !projectDescription.equals(projectResponseDTO.getDescription())) {
                throw new ApiException("Can't create project correctly. Requested project name and description are: " + projectName + "," + projectDescription + ". Actual are: " + projectResponseDTO.getName() + projectResponseDTO.getDescription());
            }
            log.info("Project {} successfully created", (Object)projectName);
        }
        if ((projects = projectApi.getProjects()).isEmpty()) {
            throw new ApiException("Project has not been created.");
        }
        testProject = SdkUtils.getProjectByNameAndDescription(projects, projectName, projectDescription);
        if (testProject == null) {
            throw new ApiException("Can retrieve project with name " + projectName);
        }
        return testProject;
    }

    public static String getServerIp() {
        return serverIp;
    }

    private static class AsyncResult<T> {
        private String error;
        T result;
        int statusCode;

        @Generated
        public AsyncResult() {
        }

        @Generated
        public String getError() {
            return this.error;
        }

        @Generated
        public T getResult() {
            return this.result;
        }

        @Generated
        public int getStatusCode() {
            return this.statusCode;
        }

        @Generated
        public void setError(String error) {
            this.error = error;
        }

        @Generated
        public void setResult(T result) {
            this.result = result;
        }

        @Generated
        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsyncResult)) {
                return false;
            }
            AsyncResult other = (AsyncResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStatusCode() != other.getStatusCode()) {
                return false;
            }
            String this$error = this.getError();
            String other$error = other.getError();
            if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
                return false;
            }
            T this$result = this.getResult();
            T other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AsyncResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStatusCode();
            String $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            T $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SdkUtils.AsyncResult(error=" + this.getError() + ", result=" + this.getResult() + ", statusCode=" + this.getStatusCode() + ")";
        }
    }

    public static interface FuncExecutor<T> {
        public void execute(@NonNull ApiCallback<T> var1) throws ApiException;

        default public boolean check(T result, int statusCode) {
            return true;
        }
    }
}

