/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.vmmigration.task;

import com.redhat.parodos.vmmigration.constants.Constants;
import com.redhat.parodos.vmmigration.dto.io.konveyor.forklift.v1beta1.Migration;
import com.redhat.parodos.vmmigration.dto.io.konveyor.forklift.v1beta1.Plan;
import com.redhat.parodos.vmmigration.util.Kubernetes;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.task.infrastructure.BaseInfrastructureWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateMigrationWorkFlowTask
extends BaseInfrastructureWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CreateMigrationWorkFlowTask.class);

    public KubernetesClient getKubernetesClient(String apiUrl, String token, String caCert) {
        Config config = Kubernetes.buildKubernetesClient(apiUrl, token, caCert);
        return new KubernetesClientBuilder().withConfig(config).build();
    }

    public WorkReport execute(WorkContext workContext) {
        log.info("Start CreateMigrationWorkFlow...");
        try {
            String apiUrl = this.getRequiredParameterValue("API_SERVER");
            String token = this.getRequiredParameterValue("TOKEN");
            String storageName = this.getRequiredParameterValue("STORAGE_NAME");
            String networkName = this.getRequiredParameterValue("NETWORK_NAME");
            String namespaceName = this.getRequiredParameterValue("NAMESPACE_NAME");
            String destinationProviderType = this.getRequiredParameterValue("DESTINATION_TYPE");
            String sourceProviderType = this.getRequiredParameterValue("SOURCE_TYPE");
            String caCert = this.getOptionalParameterValue("CA_CERT", "");
            String vmName = this.getRequiredParameterValue("VM_NAME");
            try (KubernetesClient client = this.getKubernetesClient(apiUrl, token, caCert);){
                Plan plan = Kubernetes.createPlan(vmName, storageName, networkName, namespaceName, destinationProviderType, sourceProviderType);
                MixedOperation planClient = client.resources(Plan.class);
                ((Resource)((NonNamespaceOperation)planClient.inNamespace(namespaceName)).resource((Object)plan)).create();
                MixedOperation migrationClient = client.resources(Migration.class);
                Migration migration = Kubernetes.createMigration(plan.getMetadata().getName(), namespaceName);
                ((Resource)((NonNamespaceOperation)migrationClient.inNamespace(namespaceName)).resource((Object)migration)).create();
                this.addParameter("migrationName", migration.getMetadata().getName());
                this.addParameter("API_SERVER", apiUrl);
                this.addParameter("TOKEN", token);
                if (caCert != null) {
                    this.addParameter("CA_CERT", caCert);
                }
            }
        }
        catch (MissingParameterException e) {
            log.debug("Failed to resolve required parameter: {}", (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext);
        }
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    @NonNull
    public List<WorkParameter> getWorkFlowTaskParameters() {
        return List.of(Constants.vmNameParameter, Constants.apiUrlParameter, Constants.tokenParameter, Constants.caCertParameter, Constants.namespaceNameParameter, Constants.storageNameParameter, Constants.networkNameParameter, Constants.destinationProviderTypeParameter, Constants.sourceProviderTypeParameter);
    }
}

