/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.vmmigration.checker;

import com.redhat.parodos.vmmigration.dto.io.konveyor.forklift.v1beta1.Migration;
import com.redhat.parodos.vmmigration.dto.io.konveyor.forklift.v1beta1.MigrationStatus;
import com.redhat.parodos.vmmigration.dto.io.konveyor.forklift.v1beta1.migrationstatus.Conditions;
import com.redhat.parodos.vmmigration.util.Kubernetes;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.checker.BaseWorkFlowCheckerTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationStatusWorkFlowChecker
extends BaseWorkFlowCheckerTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationStatusWorkFlowChecker.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkReport checkWorkFlowStatus(WorkContext workContext) {
        log.info("Start MigrationStatusWorkFlowChecker...");
        try {
            String migrationName = this.getRequiredParameterValue("migrationName");
            String namespaceName = this.getRequiredParameterValue("NAMESPACE_NAME");
            String apiUrl = this.getRequiredParameterValue("API_SERVER");
            String token = this.getRequiredParameterValue("TOKEN");
            String caCert = this.getOptionalParameterValue("CA_CERT", "");
            try (KubernetesClient client = this.getKubernetesClient(apiUrl, token, caCert);){
                Conditions condition;
                MixedOperation migrationClient = client.resources(Migration.class);
                Migration migration = (Migration)((Object)((Resource)((NonNamespaceOperation)migrationClient.inNamespace(namespaceName)).withName(migrationName)).get());
                MigrationStatus status = (MigrationStatus)migration.getStatus();
                List<Conditions> conditions = status.getConditions();
                Iterator<Conditions> iterator = conditions.iterator();
                do {
                    if (!iterator.hasNext()) return new DefaultWorkReport(WorkStatus.FAILED, workContext);
                } while (!(condition = iterator.next()).getType().equals("Succeeded") || !condition.getStatus().equals("True"));
                DefaultWorkReport defaultWorkReport = new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
                return defaultWorkReport;
            }
        }
        catch (MissingParameterException e) {
            log.debug("Failed to resolve required parameter: {}", (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
    }

    public KubernetesClient getKubernetesClient(String apiUrl, String token, String caCert) {
        Config config = Kubernetes.buildKubernetesClient(apiUrl, token, caCert);
        return new KubernetesClientBuilder().withConfig(config).build();
    }
}

