/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.project;

import com.redhat.parodos.infrastructure.Notifier;
import com.redhat.parodos.notification.sdk.model.NotificationMessageCreateRequestDTO;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.util.Arrays;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectAccessRequestApprovalWorkFlowTask
extends BaseWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectAccessRequestApprovalWorkFlowTask.class);
    private static final String ACCESS_REQUEST_ID = "ACCESS_REQUEST_ID";
    private static final String ACCESS_REQUEST_APPROVAL_USERNAMES = "ACCESS_REQUEST_APPROVAL_USERNAMES";
    private static final String NOTIFICATION_SUBJECT_ACCESS_REQUEST_APPROVAL = "Project Access Request Approval";
    private final String serviceUrl;
    private final Notifier notifier;

    public ProjectAccessRequestApprovalWorkFlowTask(String serviceUrl, Notifier notifier) {
        this.serviceUrl = serviceUrl;
        this.notifier = notifier;
    }

    public WorkReport execute(WorkContext workContext) {
        String approvalUsernames;
        UUID accessRequestId;
        log.info("Start projectAccessRequestApprovalWorkFlowTask...");
        try {
            accessRequestId = UUID.fromString(this.getRequiredParameterValue(ACCESS_REQUEST_ID));
            approvalUsernames = this.getRequiredParameterValue(ACCESS_REQUEST_APPROVAL_USERNAMES);
        }
        catch (MissingParameterException e) {
            log.error("Exception when trying to get required parameter(s): {}", (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        NotificationMessageCreateRequestDTO notificationMessageCreateRequestDTO = new NotificationMessageCreateRequestDTO();
        notificationMessageCreateRequestDTO.setSubject(NOTIFICATION_SUBJECT_ACCESS_REQUEST_APPROVAL);
        notificationMessageCreateRequestDTO.setUsernames(Arrays.stream(approvalUsernames.split(",")).toList());
        notificationMessageCreateRequestDTO.setBody(this.getMessage("%s/api/v1/projects/access/%s".formatted(this.serviceUrl, accessRequestId)));
        this.notifier.send(notificationMessageCreateRequestDTO);
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    private String getMessage(String url) {
        return "Hi there,\nA project request awaits your approval. Use the url below to approve or reject the request.\nUrl: " + url + "\nThank you,\nThe Parodos Team";
    }
}

