/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.ansible;

import com.redhat.parodos.tasks.ansible.AapGetJobResponseDTO;
import com.redhat.parodos.utils.RestUtils;
import com.redhat.parodos.workflow.task.checker.BaseWorkFlowCheckerTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;

public class AnsibleCompletionWorkFlowCheckerTask
extends BaseWorkFlowCheckerTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnsibleCompletionWorkFlowCheckerTask.class);
    private final String aapUrl;
    private final String username;
    private final String password;
    protected String jobId;

    public AnsibleCompletionWorkFlowCheckerTask(String aapUrl, String username, String password) {
        this.aapUrl = aapUrl;
        this.username = username;
        this.password = password;
    }

    public WorkReport checkWorkFlowStatus(WorkContext workContext) {
        block5: {
            try {
                String urlString = this.aapUrl + "/api/v2/jobs/" + this.jobId;
                ResponseEntity<AapGetJobResponseDTO> result = RestUtils.restExchange(RestUtils.ignoreSSLVerifyRestTemplate(), urlString, this.username, this.password, AapGetJobResponseDTO.class);
                AapGetJobResponseDTO responseDto = (AapGetJobResponseDTO)result.getBody();
                if (!result.getStatusCode().is2xxSuccessful() || responseDto == null) {
                    log.error("Call to the API was not successful. Response: {} ", (Object)result.getStatusCode());
                    break block5;
                }
                if ("pending".equalsIgnoreCase(responseDto.getStatus()) || "running".equalsIgnoreCase(responseDto.getStatus())) {
                    log.error("job is not completed.  Status: {}", (Object)responseDto.getStatus());
                    break block5;
                }
                if ("successful".equalsIgnoreCase(responseDto.getStatus())) {
                    log.info("Rest call completed: {}", (Object)responseDto.getStatus());
                    this.responseAction(responseDto);
                    return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
                }
                log.error("job is failed. Status: {}", (Object)responseDto.getStatus());
                return new DefaultWorkReport(WorkStatus.REJECTED, workContext);
            }
            catch (RestClientException e) {
                log.error("There was an issue with the REST call: {}", (Object)e.getMessage());
            }
        }
        return new DefaultWorkReport(WorkStatus.FAILED, workContext);
    }

    protected void responseAction(AapGetJobResponseDTO responseDTO) {
    }
}

