/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.vmmigration.checker;

import com.redhat.parodos.vmmigration.dto.io.konveyor.forklift.v1beta1.Plan;
import com.redhat.parodos.vmmigration.dto.io.konveyor.forklift.v1beta1.PlanStatus;
import com.redhat.parodos.vmmigration.dto.io.konveyor.forklift.v1beta1.planstatus.Conditions;
import com.redhat.parodos.vmmigration.util.Kubernetes;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.checker.BaseWorkFlowCheckerTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanStatusWorkFlowChecker
extends BaseWorkFlowCheckerTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlanStatusWorkFlowChecker.class);
    private static final int maxElapsedCheckTimeInMinutes = 1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkReport checkWorkFlowStatus(WorkContext workContext) {
        log.info("Start PlanStatusWorkFlowChecker...");
        try {
            String planName = this.getRequiredParameterValue("planName");
            String namespaceName = this.getRequiredParameterValue("NAMESPACE_NAME");
            String apiUrl = this.getRequiredParameterValue("API_SERVER");
            String token = this.getRequiredParameterValue("TOKEN");
            String caCert = this.getOptionalParameterValue("CA_CERT", "");
            try (KubernetesClient client = this.getKubernetesClient(apiUrl, token, caCert);){
                MixedOperation planClient = client.resources(Plan.class);
                Plan plan = (Plan)((Object)((Resource)((NonNamespaceOperation)planClient.inNamespace(namespaceName)).withName(planName)).get());
                if (plan == null) {
                    DefaultWorkReport defaultWorkReport = new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new Exception("plan %s not found".formatted(planName)));
                    return defaultWorkReport;
                }
                PlanStatus status = (PlanStatus)plan.getStatus();
                if (status == null) {
                    DefaultWorkReport defaultWorkReport = new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new Exception("no status found"));
                    return defaultWorkReport;
                }
                List<Conditions> conditions = status.getConditions();
                if (conditions == null) {
                    DefaultWorkReport defaultWorkReport = new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new Exception("no conditions found"));
                    return defaultWorkReport;
                }
                WorkStatus wStatus = WorkStatus.FAILED;
                if (conditions.size() > 0) {
                    Conditions condition = conditions.get(conditions.size() - 1);
                    log.info("condition type: {}, status {} ", (Object)condition.getType(), (Object)condition.getStatus());
                    if (condition.getType().equals("Ready") && condition.getStatus().equals("True")) {
                        wStatus = WorkStatus.COMPLETED;
                    } else if (condition.getType().equals("Critical")) {
                        log.info("condition type: {},  message: {}", (Object)condition.getType(), (Object)condition.getMessage());
                        wStatus = WorkStatus.REJECTED;
                    }
                }
                if (wStatus != WorkStatus.COMPLETED && plan.getMetadata().getCreationTimestamp() != null && Instant.parse(plan.getMetadata().getCreationTimestamp()).plus(1L, ChronoUnit.MINUTES).isAfter(Instant.now())) {
                    wStatus = WorkStatus.REJECTED;
                }
                if (wStatus != WorkStatus.FAILED) {
                    ((Resource)((NonNamespaceOperation)planClient.inNamespace(namespaceName)).withName(planName)).delete();
                }
                DefaultWorkReport defaultWorkReport = new DefaultWorkReport(wStatus, workContext);
                return defaultWorkReport;
            }
        }
        catch (MissingParameterException e) {
            log.debug("Failed to resolve required parameter: {}", (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext);
        }
    }

    public KubernetesClient getKubernetesClient(String apiUrl, String token, String caCert) {
        Config config = Kubernetes.buildKubernetesClient(apiUrl, token, caCert);
        return new KubernetesClientBuilder().withConfig(config).build();
    }
}

