/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.vmmigration;

import com.redhat.parodos.vmmigration.assessment.VmMigrationWorkFlowTask;
import com.redhat.parodos.vmmigration.checker.MigrationStatusWorkFlowChecker;
import com.redhat.parodos.vmmigration.checker.PlanStatusWorkFlowChecker;
import com.redhat.parodos.vmmigration.task.CreateMigrationWorkFlowTask;
import com.redhat.parodos.workflow.annotation.Assessment;
import com.redhat.parodos.workflow.annotation.Checker;
import com.redhat.parodos.workflow.annotation.Infrastructure;
import com.redhat.parodos.workflow.annotation.Parameter;
import com.redhat.parodos.workflow.option.WorkFlowOption;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.workflow.SequentialFlow;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class VmMigrationWorkFlowConfiguration {
    @Bean
    WorkFlowOption vmMigrationOption() {
        return new WorkFlowOption.Builder("vmMigrationOption", "vmMigrationWorkFlow_INFRASTRUCTURE_WORKFLOW").addToDetails("this is the flow to migrate the VM to OCP Virtualization").displayName("VM Migration to OCP Virtualization").setDescription("this is the flow to migrate the VM to OCP Virtualization").build();
    }

    @Bean
    VmMigrationWorkFlowTask vmMigrationWorkFlowTask(@Qualifier(value="vmMigrationOption") WorkFlowOption vmMigrationOption, @Qualifier(value="planStatusCheckerWorkflow") WorkFlow planStatusCheckerWorkflow) {
        VmMigrationWorkFlowTask assessment = new VmMigrationWorkFlowTask(List.of(vmMigrationOption));
        assessment.setWorkFlowCheckers(List.of(planStatusCheckerWorkflow));
        return assessment;
    }

    @Bean(name={"vmMigration_ASSESSMENT_WORKFLOW"})
    @Assessment(parameters={@Parameter(key="VM_NAME", description="The name of the VM to migrate from vmware to OCP Virtualization", type=WorkParameterType.TEXT, optional=false), @Parameter(key="API_SERVER", description="The URL of the kubernetes API server", type=WorkParameterType.TEXT, optional=false), @Parameter(key="TOKEN", description="The token to authenticate against the kubernetes API server", type=WorkParameterType.TEXT, optional=false), @Parameter(key="CA_CERT", description="The Certificate Authority Cert to validate the encrypted connection with the API server", type=WorkParameterType.TEXT, optional=false), @Parameter(key="NAMESPACE_NAME", description="Enter the target namespace where the VM will be migrated to inside the OCP cluster. This namespace will also need to contain the storage and network CRs required to perform the migration", type=WorkParameterType.TEXT, optional=false), @Parameter(key="STORAGE_NAME", description="Enter the name of the migration storage instance in the target namespace that will be used to migrate the VM", type=WorkParameterType.TEXT, optional=false), @Parameter(key="NETWORK_NAME", description="Enter the name of the migration network instance in the target namespace that will be used to migrate the VM", type=WorkParameterType.TEXT, optional=false), @Parameter(key="SOURCE_TYPE", description="Enter the name of the VM provider where the VM is being hosted", type=WorkParameterType.TEXT, optional=false), @Parameter(key="DESTINATION_TYPE", description="Enter the name of the VM provider where the VM will be migrated to", type=WorkParameterType.TEXT, optional=false)})
    WorkFlow VmMigrationAssessmentTask(@Qualifier(value="vmMigrationWorkFlowTask") VmMigrationWorkFlowTask vmMigrationWorkFlowTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("vmMigration_ASSESSMENT_WORKFLOW").execute((Work)vmMigrationWorkFlowTask).build();
    }

    @Bean
    CreateMigrationWorkFlowTask createMigrationFlow(@Qualifier(value="migrationStatusCheckerWorkflow") WorkFlow migrationStatusCheckerWorkflow) {
        CreateMigrationWorkFlowTask migrationWorkflow = new CreateMigrationWorkFlowTask();
        migrationWorkflow.setWorkFlowCheckers(List.of(migrationStatusCheckerWorkflow));
        return migrationWorkflow;
    }

    @Bean(name={"planStatusWorkFlowChecker"})
    PlanStatusWorkFlowChecker planStatusWorkFlowChecker() {
        return new PlanStatusWorkFlowChecker();
    }

    @Bean(name={"migrationStatusWorkFlowChecker"})
    MigrationStatusWorkFlowChecker migrationStatusWorkFlowChecker() {
        return new MigrationStatusWorkFlowChecker();
    }

    @Bean
    @Checker(cronExpression="*/5 * * * * ?")
    public WorkFlow planStatusCheckerWorkflow(@Qualifier(value="planStatusWorkFlowChecker") PlanStatusWorkFlowChecker planStatusWorkFlowChecker) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("planStatusCheckerWorkflow").execute((Work)planStatusWorkFlowChecker).build();
    }

    @Bean
    @Checker(cronExpression="0 */1 * * * ?")
    public WorkFlow migrationStatusCheckerWorkflow(@Qualifier(value="migrationStatusWorkFlowChecker") MigrationStatusWorkFlowChecker migrationStatusWorkFlowChecker) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("migrationStatusCheckerWorkflow").execute((Work)migrationStatusWorkFlowChecker).build();
    }

    @Bean(name={"vmMigrationWorkFlow_INFRASTRUCTURE_WORKFLOW"})
    @Infrastructure(parameters={@Parameter(key="VM_NAME", description="The name of the VM to migrate from vmware to OCP Virtualization", type=WorkParameterType.TEXT, optional=false), @Parameter(key="API_SERVER", description="The URL of the kubernetes API server", type=WorkParameterType.TEXT, optional=false), @Parameter(key="TOKEN", description="The token to authenticate against the kubernetes API server", type=WorkParameterType.TEXT, optional=false), @Parameter(key="CA_CERT", description="The Certificate Authority Cert to validate the encrypted connection with the API server", type=WorkParameterType.TEXT, optional=true), @Parameter(key="NAMESPACE_NAME", description="Enter the target namespace where the VM will be migrated to inside the OCP cluster. This namespace will also need to contain the storage and network CRs required to perform the migration", type=WorkParameterType.TEXT, optional=false), @Parameter(key="STORAGE_NAME", description="Enter the name of the migration storage instance in the target namespace that will be used to migrate the VM", type=WorkParameterType.TEXT, optional=false), @Parameter(key="NETWORK_NAME", description="Enter the name of the migration network instance in the target namespace that will be used to migrate the VM", type=WorkParameterType.TEXT, optional=false), @Parameter(key="SOURCE_TYPE", description="Enter the name of the VM provider where the VM is being hosted", type=WorkParameterType.TEXT, optional=false), @Parameter(key="DESTINATION_TYPE", description="Enter the name of the VM provider where the VM will be migrated to", type=WorkParameterType.TEXT, optional=false)})
    WorkFlow vmMigrationWorkFlow(@Qualifier(value="createMigrationFlow") CreateMigrationWorkFlowTask createMigrationWorkFlow) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("vmMigrationWorkFlow_INFRASTRUCTURE_WORKFLOW").execute((Work)createMigrationWorkFlow).build();
    }
}

