/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.rest;

import com.redhat.parodos.tasks.rest.RestService;
import com.redhat.parodos.tasks.rest.RestServiceImpl;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflow.task.enums.WorkFlowTaskOutput;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;

public class RestWorkFlowTask
extends BaseWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestWorkFlowTask.class);
    private RestService restService;

    public RestWorkFlowTask() {
        this.restService = new RestServiceImpl();
    }

    RestWorkFlowTask(String beanName, RestService restService) {
        this.restService = restService;
        this.setBeanName(beanName);
    }

    @NonNull
    public List<WorkParameter> getWorkFlowTaskParameters() {
        LinkedList<WorkParameter> params = new LinkedList<WorkParameter>();
        params.add(WorkParameter.builder().key("url").type(WorkParameterType.TEXT).optional(false).description("URL to send request to").build());
        params.add(WorkParameter.builder().key("method").type(WorkParameterType.TEXT).optional(false).description("The HTTP method").build());
        params.add(WorkParameter.builder().key("content").type(WorkParameterType.TEXT).optional(true).description("The content of the HTTP request").build());
        params.add(WorkParameter.builder().key("username").type(WorkParameterType.TEXT).optional(true).description("Username for basic HTTP authentication").build());
        params.add(WorkParameter.builder().key("password").type(WorkParameterType.TEXT).optional(true).description("Password for basic HTTP authentication").build());
        params.add(WorkParameter.builder().key("response-key").type(WorkParameterType.TEXT).optional(true).description("The content of the response will be stored in this key").build());
        return params;
    }

    @NonNull
    public List<WorkFlowTaskOutput> getWorkFlowTaskOutputs() {
        return List.of(WorkFlowTaskOutput.OTHER);
    }

    public WorkReport execute(WorkContext workContext) {
        String url = "";
        try {
            url = this.getRequiredParameterValue("url");
            String method = this.getRequiredParameterValue("method");
            HttpMethod httpMethod = Arrays.stream(HttpMethod.values()).filter(m -> m.name().equals(method.toUpperCase())).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid HTTP method: " + method));
            ResponseEntity<String> responseEntity = this.restService.exchange(url, httpMethod, this.buildRequestEntity(workContext));
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                throw new RestClientException("Request failed with HTTP status code " + responseEntity.getStatusCodeValue());
            }
            this.processResponseEntity(workContext, responseEntity);
        }
        catch (MissingParameterException | IllegalArgumentException e) {
            log.error("Rest task failed for url " + url, e);
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, e);
        }
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    protected void processResponseEntity(WorkContext workContext, ResponseEntity<String> responseEntity) throws RestClientException {
        String responseKey = this.getOptionalParameterValue("response-key", "");
        if (responseKey.isEmpty()) {
            return;
        }
        workContext.put(responseKey, responseEntity.getBody());
    }

    protected HttpEntity<String> buildRequestEntity(WorkContext workContext) throws RestClientException {
        String content = this.getOptionalParameterValue("content", "");
        return new HttpEntity((Object)content, (MultiValueMap)this.buildHttpHeaders(workContext));
    }

    protected HttpHeaders buildHttpHeaders(WorkContext workContext) throws RestClientException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        httpHeaders.setAccept(List.of(MediaType.APPLICATION_JSON));
        String username = this.getOptionalParameterValue("username", "");
        if (!username.isEmpty()) {
            String password;
            try {
                password = this.getRequiredParameterValue("password");
            }
            catch (MissingParameterException e) {
                throw new RestClientException("Missing password", (Throwable)e);
            }
            httpHeaders.setBasicAuth(username, password);
        }
        return httpHeaders;
    }
}

