/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.project.escalation;

import com.redhat.parodos.infrastructure.Notifier;
import com.redhat.parodos.notification.sdk.model.NotificationMessageCreateRequestDTO;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectAccessRequestEscalationWorkFlowTask
extends BaseWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectAccessRequestEscalationWorkFlowTask.class);
    private static final String ACCESS_REQUEST_ID = "ACCESS_REQUEST_ID";
    private static final String ACCESS_REQUEST_ESCALATION_USERNAME = "ACCESS_REQUEST_ESCALATION_USERNAME";
    private static final String NOTIFICATION_SUBJECT_ACCESS_REQUEST_ESCALATION = "Project Access Request Escalation";
    private final String serviceUrl;
    private final Notifier notifier;

    public ProjectAccessRequestEscalationWorkFlowTask(String serviceUrl, Notifier notifier) {
        this.serviceUrl = serviceUrl;
        this.notifier = notifier;
    }

    public WorkReport execute(WorkContext workContext) {
        String escalationUsername;
        UUID accessRequestId;
        log.info("Start projectAccessRequestEscalationWorkFlowTask...");
        try {
            accessRequestId = UUID.fromString(this.getRequiredParameterValue(ACCESS_REQUEST_ID));
            escalationUsername = this.getRequiredParameterValue(ACCESS_REQUEST_ESCALATION_USERNAME);
        }
        catch (MissingParameterException e) {
            log.error("Exception when trying to get required parameter(s): {}", (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        NotificationMessageCreateRequestDTO notificationMessageCreateRequestDTO = new NotificationMessageCreateRequestDTO();
        notificationMessageCreateRequestDTO.setSubject(NOTIFICATION_SUBJECT_ACCESS_REQUEST_ESCALATION);
        notificationMessageCreateRequestDTO.addUsernamesItem(escalationUsername);
        notificationMessageCreateRequestDTO.setBody(this.getMessage("%s/api/v1/projects/access/%s/status".formatted(this.serviceUrl, accessRequestId)));
        this.notifier.send(notificationMessageCreateRequestDTO);
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    private String getMessage(String url) {
        return "Hi there,\nA project request below has been escalated as being pending for a while.\nUrl: " + url + "\nThank you,\nThe Parodos Team";
    }
}

