/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.project.checker;

import com.redhat.parodos.tasks.project.dto.AccessStatusResponseDTO;
import com.redhat.parodos.utils.RestUtils;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.checker.BaseWorkFlowCheckerTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class ProjectAccessRequestApprovalWorkFlowCheckerTask
extends BaseWorkFlowCheckerTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectAccessRequestApprovalWorkFlowCheckerTask.class);
    private static final String ACCESS_REQUEST_ID = "ACCESS_REQUEST_ID";
    private final String serviceUrl;
    private final String serviceUsername;
    private final String servicePassword;

    public ProjectAccessRequestApprovalWorkFlowCheckerTask(WorkFlow projectAccessRequestApprovalEscalationWorkFlow, long sla, String serviceUrl, String serviceUsername, String servicePassword) {
        super(projectAccessRequestApprovalEscalationWorkFlow, sla);
        this.serviceUrl = serviceUrl;
        this.serviceUsername = serviceUsername;
        this.servicePassword = servicePassword;
    }

    public WorkReport checkWorkFlowStatus(WorkContext workContext) {
        UUID accessRequestId;
        log.info("Start projectAccessRequestApprovalWorkFlowCheckerTask...");
        try {
            accessRequestId = UUID.fromString(this.getRequiredParameterValue(ACCESS_REQUEST_ID));
        }
        catch (MissingParameterException e) {
            log.error("Exception when trying to get required parameter: {}", (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        try {
            String urlString = "%s/api/v1/projects/access/%s/status".formatted(this.serviceUrl, accessRequestId);
            ResponseEntity<AccessStatusResponseDTO> responseDTO = RestUtils.restExchange(urlString, this.serviceUsername, this.servicePassword, AccessStatusResponseDTO.class);
            if (!responseDTO.getStatusCode().is2xxSuccessful()) {
                log.error("Call to the api was not successful: {}", (Object)responseDTO.getStatusCode());
            } else {
                log.info("Rest call completed with response: {}", responseDTO.getBody());
                switch (Objects.requireNonNull((AccessStatusResponseDTO)responseDTO.getBody()).getStatus()) {
                    case APPROVED: {
                        log.info("Project access request {} is approved", (Object)((AccessStatusResponseDTO)responseDTO.getBody()).getAccessRequestId());
                        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
                    }
                    case REJECTED: {
                        log.info("Project access request {} is rejected", (Object)((AccessStatusResponseDTO)responseDTO.getBody()).getAccessRequestId());
                        return new DefaultWorkReport(WorkStatus.REJECTED, workContext);
                    }
                }
                log.info("Project access request {} is waiting for approval", (Object)((AccessStatusResponseDTO)responseDTO.getBody()).getAccessRequestId());
            }
        }
        catch (Exception e) {
            log.error("There was an issue with the REST call: {}", (Object)e.getMessage());
        }
        return new DefaultWorkReport(WorkStatus.FAILED, workContext);
    }
}

