/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.project;

import com.redhat.parodos.project.enums.Role;
import com.redhat.parodos.tasks.project.dto.AccessRequestDTO;
import com.redhat.parodos.tasks.project.dto.AccessResponseDTO;
import com.redhat.parodos.utils.RestUtils;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class ProjectAccessRequestWorkFlowTask
extends BaseWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectAccessRequestWorkFlowTask.class);
    private static final String PARAMETER_USERNAME = "USERNAME";
    private static final String PARAMETER_ROLE = "ROLE";
    private static final String PARAMETER_ROLE_DEFAULT = "DEVELOPER";
    private static final String ACCESS_REQUEST_ID = "ACCESS_REQUEST_ID";
    private static final String ACCESS_REQUEST_APPROVAL_USERNAMES = "ACCESS_REQUEST_APPROVAL_USERNAMES";
    private static final String ACCESS_REQUEST_ESCALATION_USERNAME = "ACCESS_REQUEST_ESCALATION_USERNAME";
    private final String serviceUrl;
    private final String serviceUsername;
    private final String servicePassword;

    public ProjectAccessRequestWorkFlowTask(String serviceUrl, String serviceUsername, String servicePassword) {
        this.serviceUrl = serviceUrl;
        this.serviceUsername = serviceUsername;
        this.servicePassword = servicePassword;
    }

    public WorkReport execute(WorkContext workContext) {
        String role;
        String username;
        try {
            username = this.getRequiredParameterValue(PARAMETER_USERNAME);
            role = this.getOptionalParameterValue(PARAMETER_ROLE, PARAMETER_ROLE_DEFAULT, false);
            log.info("Project access request with the following - username: {}, role: {}", (Object)username, (Object)role);
        }
        catch (MissingParameterException e) {
            log.error("Exception when trying to get required parameter(s): {}", (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        try {
            Role.valueOf((String)role.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            log.error("Exception when trying to convert role requested: {}", (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        try {
            String urlString = "%s/api/v1/projects/%s/access".formatted(this.serviceUrl, this.getProjectId(workContext));
            AccessRequestDTO requestDTO = AccessRequestDTO.builder().username(username).role(Role.valueOf((String)role.toUpperCase())).build();
            ResponseEntity<AccessResponseDTO> responseDTO = RestUtils.executePost(urlString, requestDTO, this.serviceUsername, this.servicePassword, AccessResponseDTO.class);
            if (responseDTO.getStatusCode().is2xxSuccessful()) {
                log.info("Rest call completed with response: {}", responseDTO.getBody());
                this.addParameter(ACCESS_REQUEST_ID, Objects.requireNonNull((AccessResponseDTO)responseDTO.getBody()).getAccessRequestId().toString());
                this.addParameter(ACCESS_REQUEST_APPROVAL_USERNAMES, String.join((CharSequence)",", Objects.requireNonNull((AccessResponseDTO)responseDTO.getBody()).getApprovalSentTo()));
                this.addParameter(ACCESS_REQUEST_ESCALATION_USERNAME, String.join((CharSequence)",", Objects.requireNonNull((AccessResponseDTO)responseDTO.getBody()).getEscalationSentTo()));
                return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
            }
            log.error("Call to the api was not successful with status code: {}", (Object)responseDTO.getStatusCode());
        }
        catch (Exception e) {
            log.error("There was an issue with the REST call: {}", (Object)e.getMessage());
        }
        return new DefaultWorkReport(WorkStatus.FAILED, workContext);
    }

    @NonNull
    public List<WorkParameter> getWorkFlowTaskParameters() {
        return List.of(WorkParameter.builder().key(PARAMETER_USERNAME).type(WorkParameterType.TEXT).optional(false).description("The project id to assign user into").build(), WorkParameter.builder().key(PARAMETER_ROLE).type(WorkParameterType.TEXT).optional(true).description("The role to grant to the user").build());
    }
}

