/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.project.escalation;

import com.redhat.parodos.tasks.project.dto.NotificationRequest;
import com.redhat.parodos.utils.RestUtils;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;

public class ProjectAccessRequestEscalationWorkFlowTask
extends BaseWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectAccessRequestEscalationWorkFlowTask.class);
    private final String serviceUrl;
    private final String servicePort;
    private final String notificationServiceUrl;
    private final String notificationServicePort;
    private final String notificationServiceAccountName;
    private final String notificationServiceAccountPassword;

    public ProjectAccessRequestEscalationWorkFlowTask(String serviceUrl, String servicePort, String notificationServiceUrl, String notificationServicePort, String notificationServiceAccountName, String notificationServiceAccountPassword) {
        this.serviceUrl = serviceUrl;
        this.servicePort = servicePort;
        this.notificationServiceUrl = notificationServiceUrl;
        this.notificationServicePort = notificationServicePort;
        this.notificationServiceAccountName = notificationServiceAccountName;
        this.notificationServiceAccountPassword = notificationServiceAccountPassword;
    }

    public WorkReport execute(WorkContext workContext) {
        String escalationUsername;
        UUID accessRequestId;
        log.info("Start projectAccessRequestEscalationWorkFlowTask...");
        try {
            accessRequestId = UUID.fromString(this.getRequiredParameterValue("ACCESS_REQUEST_ID"));
            escalationUsername = this.getRequiredParameterValue("ACCESS_REQUEST_ESCALATION_USERNAME");
        }
        catch (MissingParameterException e) {
            log.error("Exception when trying to get required parameter(s): {}", (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        String projectAccessRequestStatusUrl = String.format("%s:%s/api/v1/projects/access/%s/status", this.serviceUrl, this.servicePort, accessRequestId);
        NotificationRequest request = NotificationRequest.builder().usernames(List.of(escalationUsername)).subject("Project Access Request Escalation").body(this.getMessage(projectAccessRequestStatusUrl)).build();
        HttpEntity<NotificationRequest> notificationRequestHttpEntity = RestUtils.getRequestWithHeaders(request, this.notificationServiceAccountName, this.notificationServiceAccountPassword);
        ResponseEntity<String> response = RestUtils.executePost(String.format("%s:%s/api/v1/messages", this.notificationServiceUrl, this.notificationServicePort), notificationRequestHttpEntity);
        try {
            if (response.getStatusCode().is2xxSuccessful()) {
                log.info("Rest call completed: {}", response.getBody());
                return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
            }
            log.error("Call to the API was not successful. Response: {}", (Object)response.getStatusCode());
        }
        catch (Exception e) {
            log.error("There was an issue with the REST call: {}", (Object)e.getMessage());
        }
        return new DefaultWorkReport(WorkStatus.FAILED, workContext);
    }

    private String getMessage(String url) {
        return "Hi there,\nA project request below has been escalated as being pending for a while.\nUrl: " + url + "\nThank you,\nThe Parodos Team";
    }
}

