/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.git;

import com.google.common.base.Strings;
import com.redhat.parodos.tasks.git.GitUtils;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitPushTask
extends BaseWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitPushTask.class);

    @NonNull
    public List<WorkParameter> getWorkFlowTaskParameters() {
        return List.of(WorkParameter.builder().key("path").type(WorkParameterType.TEXT).optional(true).description("path where the git repo is located").build(), WorkParameter.builder().key("remote").type(WorkParameterType.TEXT).optional(false).description("path where the git repo is located").build(), WorkParameter.builder().key("credentials").type(WorkParameterType.TEXT).optional(true).description("Git credential").build());
    }

    public String getRepoPath(WorkContext workContext) {
        return GitUtils.getRepoPath(workContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkReport execute(WorkContext workContext) {
        String path = this.getRepoPath(workContext);
        if (Strings.isNullOrEmpty((String)path)) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new IllegalArgumentException("The path parameter cannot be null or empty"));
        }
        String remote = "";
        try (Repository repo = null;){
            remote = this.getRequiredParameterValue("remote");
            String credentials = this.getOptionalParameterValue("credentials", "");
            repo = this.getRepo(path);
            this.push(repo, remote, credentials);
        }
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    private Repository getRepo(String path) throws IOException {
        return GitUtils.getRepo(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(Repository repo, String remoteName, String credentials) throws FileNotFoundException, IOException, GitAPIException {
        try (Git git = new Git(repo);){
            PushCommand push = git.push().setForce(false).setRemote(remoteName);
            if (!Strings.isNullOrEmpty((String)credentials)) {
                push.setTransportConfigCallback(GitUtils.getTransport(Path.of(credentials, new String[0])));
            }
            push.call();
        }
    }

    @Generated
    public GitPushTask() {
    }
}

