/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.git;

import com.google.common.base.Strings;
import com.redhat.parodos.tasks.git.GitUtils;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitCommitTask
extends BaseWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitCommitTask.class);

    @NonNull
    public List<WorkParameter> getWorkFlowTaskParameters() {
        return List.of(WorkParameter.builder().key("path").type(WorkParameterType.TEXT).optional(true).description("path where the git repo is located").build(), WorkParameter.builder().key("commitMessage").type(WorkParameterType.TEXT).optional(false).description("Commit message for all the files").build());
    }

    public String getRepoPath(WorkContext workContext) {
        return GitUtils.getRepoPath(workContext);
    }

    public WorkReport execute(WorkContext workContext) {
        String commitMessage = null;
        try {
            commitMessage = this.getRequiredParameterValue("commitMessage");
        }
        catch (MissingParameterException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        String path = this.getRepoPath(workContext);
        if (Strings.isNullOrEmpty((String)path)) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new IllegalArgumentException("The path parameter cannot be null or empty"));
        }
        try (Repository repo = this.getRepo(path);){
            Git git = new Git(repo);
            git.add().addFilepattern(".").call();
            CommitCommand commit = git.commit().setMessage(commitMessage);
            commit.setSign(Boolean.FALSE);
            commit.call();
        }
        catch (IOException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new RuntimeException("No repository at '%s' error: %s".formatted(path, e.getMessage())));
        }
        catch (Exception e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new RuntimeException("Cannot create the commit on the repository: %s".formatted(e)));
        }
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    private Repository getRepo(String path) throws IOException {
        return GitUtils.getRepo(path);
    }

    @Generated
    public GitCommitTask() {
    }
}

