/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.project.checker;

import com.redhat.parodos.project.enums.ProjectAccessStatus;
import com.redhat.parodos.utils.RestUtils;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.checker.BaseWorkFlowCheckerTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class ProjectAccessRequestApprovalWorkFlowCheckerTask
extends BaseWorkFlowCheckerTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectAccessRequestApprovalWorkFlowCheckerTask.class);
    private final String serviceUrl;
    private final String servicePort;
    private final String serviceAccountUsername;
    private final String serviceAccountPassword;

    public ProjectAccessRequestApprovalWorkFlowCheckerTask(WorkFlow projectAccessRequestApprovalEscalationWorkFlow, long sla, String serviceUrl, String servicePort, String serviceAccountUsername, String serviceAccountPassword) {
        super(projectAccessRequestApprovalEscalationWorkFlow, sla);
        this.serviceUrl = serviceUrl;
        this.servicePort = servicePort;
        this.serviceAccountUsername = serviceAccountUsername;
        this.serviceAccountPassword = serviceAccountPassword;
    }

    public WorkReport checkWorkFlowStatus(WorkContext workContext) {
        UUID accessRequestId;
        log.info("Start ProjectAccessRequestApprovalWorkFlowCheckerTask...");
        try {
            accessRequestId = UUID.fromString(this.getRequiredParameterValue("ACCESS_REQUEST_ID"));
        }
        catch (MissingParameterException e) {
            log.error("Exception when trying to get required parameter(s): {}", (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        try {
            String url = String.format("%s:%s/api/v1/projects/access/%s/status", this.serviceUrl, this.servicePort, accessRequestId);
            ResponseEntity<AccessStatusResponseDTO> responseDTO = RestUtils.restExchange(url, this.serviceAccountUsername, this.serviceAccountPassword, AccessStatusResponseDTO.class);
            if (!responseDTO.getStatusCode().is2xxSuccessful()) {
                log.error("Call to the api was not successful: {}", (Object)responseDTO.getStatusCode());
            } else {
                log.info("Rest call completed with response: {}", responseDTO.getBody());
                switch (Objects.requireNonNull((AccessStatusResponseDTO)responseDTO.getBody()).getStatus()) {
                    case APPROVED: {
                        log.info("Project access request {} is approved", (Object)((AccessStatusResponseDTO)responseDTO.getBody()).getAccessRequestId());
                        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
                    }
                    case REJECTED: {
                        log.info("Project access request {} is rejected", (Object)((AccessStatusResponseDTO)responseDTO.getBody()).getAccessRequestId());
                        return new DefaultWorkReport(WorkStatus.REJECTED, workContext);
                    }
                }
                log.info("Project access request {} is waiting for approval", (Object)((AccessStatusResponseDTO)responseDTO.getBody()).getAccessRequestId());
            }
        }
        catch (Exception e) {
            log.error("There was an issue with the REST call: {}", (Object)e.getMessage());
        }
        return new DefaultWorkReport(WorkStatus.FAILED, workContext);
    }

    private static class AccessStatusResponseDTO {
        private UUID accessRequestId;
        private ProjectAccessStatus status;

        @Generated
        public static AccessStatusResponseDTOBuilder builder() {
            return new AccessStatusResponseDTOBuilder();
        }

        @Generated
        public UUID getAccessRequestId() {
            return this.accessRequestId;
        }

        @Generated
        public ProjectAccessStatus getStatus() {
            return this.status;
        }

        @Generated
        public void setAccessRequestId(UUID accessRequestId) {
            this.accessRequestId = accessRequestId;
        }

        @Generated
        public void setStatus(ProjectAccessStatus status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AccessStatusResponseDTO)) {
                return false;
            }
            AccessStatusResponseDTO other = (AccessStatusResponseDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$accessRequestId = this.getAccessRequestId();
            UUID other$accessRequestId = other.getAccessRequestId();
            if (this$accessRequestId == null ? other$accessRequestId != null : !((Object)this$accessRequestId).equals(other$accessRequestId)) {
                return false;
            }
            ProjectAccessStatus this$status = this.getStatus();
            ProjectAccessStatus other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AccessStatusResponseDTO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $accessRequestId = this.getAccessRequestId();
            result = result * 59 + ($accessRequestId == null ? 43 : ((Object)$accessRequestId).hashCode());
            ProjectAccessStatus $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ProjectAccessRequestApprovalWorkFlowCheckerTask.AccessStatusResponseDTO(accessRequestId=" + this.getAccessRequestId() + ", status=" + this.getStatus() + ")";
        }

        @Generated
        public AccessStatusResponseDTO(UUID accessRequestId, ProjectAccessStatus status) {
            this.accessRequestId = accessRequestId;
            this.status = status;
        }

        @Generated
        public AccessStatusResponseDTO() {
        }

        @Generated
        public static class AccessStatusResponseDTOBuilder {
            @Generated
            private UUID accessRequestId;
            @Generated
            private ProjectAccessStatus status;

            @Generated
            AccessStatusResponseDTOBuilder() {
            }

            @Generated
            public AccessStatusResponseDTOBuilder accessRequestId(UUID accessRequestId) {
                this.accessRequestId = accessRequestId;
                return this;
            }

            @Generated
            public AccessStatusResponseDTOBuilder status(ProjectAccessStatus status) {
                this.status = status;
                return this;
            }

            @Generated
            public AccessStatusResponseDTO build() {
                return new AccessStatusResponseDTO(this.accessRequestId, this.status);
            }

            @Generated
            public String toString() {
                return "ProjectAccessRequestApprovalWorkFlowCheckerTask.AccessStatusResponseDTO.AccessStatusResponseDTOBuilder(accessRequestId=" + this.accessRequestId + ", status=" + this.status + ")";
            }
        }
    }
}

