/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.project;

import com.redhat.parodos.project.enums.Role;
import com.redhat.parodos.utils.RestUtils;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class ProjectAccessRequestWorkFlowTask
extends BaseWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectAccessRequestWorkFlowTask.class);
    private final String serviceUrl;
    private final String servicePort;
    private final String serviceAccountUsername;
    private final String serviceAccountPassword;

    public ProjectAccessRequestWorkFlowTask(String serviceUrl, String servicePort, String serviceAccountUsername, String serviceAccountPassword) {
        this.serviceUrl = serviceUrl;
        this.servicePort = servicePort;
        this.serviceAccountUsername = serviceAccountUsername;
        this.serviceAccountPassword = serviceAccountPassword;
    }

    public WorkReport execute(WorkContext workContext) {
        String role;
        String username;
        try {
            username = this.getRequiredParameterValue("USERNAME");
            role = this.getOptionalParameterValue("ROLE", "DEVELOPER", false);
            log.info("Project access request with the following - username: {}, role: {}", (Object)username, (Object)role);
        }
        catch (MissingParameterException e) {
            log.error("Exception when trying to get required parameter(s): {}", (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        try {
            Role.valueOf((String)role.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            log.error("Exception when trying to convert role requested: {}", (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        try {
            String url = String.format("%s:%s/api/v1/projects/%s/access", this.serviceUrl, this.servicePort, this.getProjectId(workContext));
            log.info("url: {}", (Object)url);
            AccessRequestDTO requestDTO = AccessRequestDTO.builder().username(username).role(Role.valueOf((String)role.toUpperCase())).build();
            ResponseEntity<AccessResponseDTO> responseDTO = RestUtils.executePost(url, requestDTO, this.serviceAccountUsername, this.serviceAccountPassword, AccessResponseDTO.class);
            if (responseDTO.getStatusCode().is2xxSuccessful()) {
                log.info("Rest call completed with response: {}", responseDTO.getBody());
                this.addParameter("ACCESS_REQUEST_ID", Objects.requireNonNull((AccessResponseDTO)responseDTO.getBody()).accessRequestId.toString());
                this.addParameter("ACCESS_REQUEST_APPROVAL_USERNAMES", String.join((CharSequence)",", Objects.requireNonNull((AccessResponseDTO)responseDTO.getBody()).getApprovalSentTo()));
                this.addParameter("ACCESS_REQUEST_ESCALATION_USERNAME", String.join((CharSequence)",", Objects.requireNonNull((AccessResponseDTO)responseDTO.getBody()).getEscalationSentTo()));
                return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
            }
            log.error("Call to the api was not successful with status code: {}", (Object)responseDTO.getStatusCode());
        }
        catch (Exception e) {
            log.error("There was an issue with the REST call: {}", (Object)e.getMessage());
        }
        return new DefaultWorkReport(WorkStatus.FAILED, workContext);
    }

    @NonNull
    public List<WorkParameter> getWorkFlowTaskParameters() {
        return List.of(WorkParameter.builder().key("USERNAME").type(WorkParameterType.TEXT).optional(false).description("The project id to assign user into").build(), WorkParameter.builder().key("ROLE").type(WorkParameterType.TEXT).optional(true).description("The role to grant to the user").build());
    }

    private static class AccessRequestDTO {
        private String username;
        private Role role;

        @Generated
        AccessRequestDTO(String username, Role role) {
            this.username = username;
            this.role = role;
        }

        @Generated
        public static AccessRequestDTOBuilder builder() {
            return new AccessRequestDTOBuilder();
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public Role getRole() {
            return this.role;
        }

        @Generated
        public void setUsername(String username) {
            this.username = username;
        }

        @Generated
        public void setRole(Role role) {
            this.role = role;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AccessRequestDTO)) {
                return false;
            }
            AccessRequestDTO other = (AccessRequestDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            Role this$role = this.getRole();
            Role other$role = other.getRole();
            return !(this$role == null ? other$role != null : !this$role.equals(other$role));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AccessRequestDTO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            Role $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ProjectAccessRequestWorkFlowTask.AccessRequestDTO(username=" + this.getUsername() + ", role=" + this.getRole() + ")";
        }

        @Generated
        public static class AccessRequestDTOBuilder {
            @Generated
            private String username;
            @Generated
            private Role role;

            @Generated
            AccessRequestDTOBuilder() {
            }

            @Generated
            public AccessRequestDTOBuilder username(String username) {
                this.username = username;
                return this;
            }

            @Generated
            public AccessRequestDTOBuilder role(Role role) {
                this.role = role;
                return this;
            }

            @Generated
            public AccessRequestDTO build() {
                return new AccessRequestDTO(this.username, this.role);
            }

            @Generated
            public String toString() {
                return "ProjectAccessRequestWorkFlowTask.AccessRequestDTO.AccessRequestDTOBuilder(username=" + this.username + ", role=" + this.role + ")";
            }
        }
    }

    private static class AccessResponseDTO {
        private UUID accessRequestId;
        private List<String> approvalSentTo;
        private String escalationSentTo;

        @Generated
        public AccessResponseDTO() {
        }

        @Generated
        public UUID getAccessRequestId() {
            return this.accessRequestId;
        }

        @Generated
        public List<String> getApprovalSentTo() {
            return this.approvalSentTo;
        }

        @Generated
        public String getEscalationSentTo() {
            return this.escalationSentTo;
        }

        @Generated
        public void setAccessRequestId(UUID accessRequestId) {
            this.accessRequestId = accessRequestId;
        }

        @Generated
        public void setApprovalSentTo(List<String> approvalSentTo) {
            this.approvalSentTo = approvalSentTo;
        }

        @Generated
        public void setEscalationSentTo(String escalationSentTo) {
            this.escalationSentTo = escalationSentTo;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AccessResponseDTO)) {
                return false;
            }
            AccessResponseDTO other = (AccessResponseDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$accessRequestId = this.getAccessRequestId();
            UUID other$accessRequestId = other.getAccessRequestId();
            if (this$accessRequestId == null ? other$accessRequestId != null : !((Object)this$accessRequestId).equals(other$accessRequestId)) {
                return false;
            }
            List<String> this$approvalSentTo = this.getApprovalSentTo();
            List<String> other$approvalSentTo = other.getApprovalSentTo();
            if (this$approvalSentTo == null ? other$approvalSentTo != null : !((Object)this$approvalSentTo).equals(other$approvalSentTo)) {
                return false;
            }
            String this$escalationSentTo = this.getEscalationSentTo();
            String other$escalationSentTo = other.getEscalationSentTo();
            return !(this$escalationSentTo == null ? other$escalationSentTo != null : !this$escalationSentTo.equals(other$escalationSentTo));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AccessResponseDTO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $accessRequestId = this.getAccessRequestId();
            result = result * 59 + ($accessRequestId == null ? 43 : ((Object)$accessRequestId).hashCode());
            List<String> $approvalSentTo = this.getApprovalSentTo();
            result = result * 59 + ($approvalSentTo == null ? 43 : ((Object)$approvalSentTo).hashCode());
            String $escalationSentTo = this.getEscalationSentTo();
            result = result * 59 + ($escalationSentTo == null ? 43 : $escalationSentTo.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ProjectAccessRequestWorkFlowTask.AccessResponseDTO(accessRequestId=" + this.getAccessRequestId() + ", approvalSentTo=" + this.getApprovalSentTo() + ", escalationSentTo=" + this.getEscalationSentTo() + ")";
        }
    }
}

