/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.migrationtoolkit;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.redhat.parodos.tasks.migrationtoolkit.App;
import com.redhat.parodos.tasks.migrationtoolkit.Identity;
import com.redhat.parodos.tasks.migrationtoolkit.MTAApplicationClient;
import com.redhat.parodos.tasks.migrationtoolkit.MTATaskGroupClient;
import com.redhat.parodos.tasks.migrationtoolkit.Result;
import com.redhat.parodos.tasks.migrationtoolkit.TaskGroup;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.NotFoundException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MTAClient
implements MTAApplicationClient,
MTATaskGroupClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MTAClient.class);
    private final HttpClient client;
    private final URI serverURI;
    private final String bearerToken;
    private final ObjectMapper mapper;

    MTAClient(URI serverURI, String bearerToken) {
        this.serverURI = serverURI;
        this.bearerToken = bearerToken;
        this.mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            SSLContext nonValidatingSSLContext = SSLContext.getInstance("SSL");
            nonValidatingSSLContext.init(null, new TrustManager[]{new nonValidatingTrustManager()}, SecureRandom.getInstanceStrong());
            this.client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).sslContext(nonValidatingSSLContext).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Result<App> get(String name) {
        try {
            HttpResponse<String> getAll = this.client.send(HttpRequest.newBuilder().GET().uri(this.serverURI.resolve("/hub/applications")).build(), HttpResponse.BodyHandlers.ofString());
            if (getAll.statusCode() != 200) {
                return new Result.Failure<App>(null);
            }
            List apps = (List)this.mapper.readValue(getAll.body(), (TypeReference)new TypeReference<List<App>>(){});
            Optional<App> app = apps.stream().filter(v -> v.name().equals(name)).findFirst();
            if (app.isPresent()) {
                return new Result.Success<App>(app.get());
            }
            return new Result.Failure<App>((Throwable)new NotFoundException("failed to find application by name " + name));
        }
        catch (IOException | InterruptedException e) {
            return new Result.Failure<App>(e);
        }
    }

    @Override
    public Result<Identity> getIdentity(String name) {
        try {
            HttpResponse<String> getAll = this.client.send(HttpRequest.newBuilder().GET().uri(this.serverURI.resolve("/hub/identities")).build(), HttpResponse.BodyHandlers.ofString());
            if (getAll.statusCode() != 200) {
                return null;
            }
            List identities = (List)this.mapper.readValue(getAll.body(), (TypeReference)new TypeReference<List<Identity>>(){});
            Optional<Identity> identity = identities.stream().filter(v -> v.name().equals(name)).findFirst();
            if (identity.isPresent()) {
                return new Result.Success<Identity>(identity.get());
            }
            return new Result.Failure<Identity>((Throwable)new NotFoundException("failed to find identity by name " + name));
        }
        catch (IOException | InterruptedException e) {
            return new Result.Failure<Identity>(e);
        }
    }

    @Override
    public Result<App> create(App app) {
        try {
            String body = this.mapper.writeValueAsString((Object)app);
            HttpResponse<String> create = this.client.send(HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(body)).uri(this.serverURI.resolve("/hub/applications")).build(), HttpResponse.BodyHandlers.ofString());
            if (create.statusCode() != 201) {
                return new Result.Failure<App>(null);
            }
            App newApp = (App)this.mapper.readValue(create.body(), (TypeReference)new TypeReference<App>(){});
            return new Result.Success<App>(newApp);
        }
        catch (IOException | InterruptedException e) {
            return new Result.Failure<App>(e);
        }
    }

    @Override
    public Result<TaskGroup> create(int appId) {
        try {
            TaskGroup tgnew = TaskGroup.ofCloudReadiness(appId);
            String body = this.mapper.writeValueAsString((Object)tgnew);
            log.debug("creating an MTA taskgroup for application ID {}", (Object)appId);
            HttpResponse<String> postTG = this.client.send(HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(body)).uri(this.serverURI.resolve("/hub/taskgroups")).build(), HttpResponse.BodyHandlers.ofString());
            TaskGroup tg = (TaskGroup)this.mapper.readValue(postTG.body(), (TypeReference)new TypeReference<TaskGroup>(){});
            body = this.mapper.writeValueAsString((Object)tg);
            HttpResponse<String> submitTG = this.client.send(HttpRequest.newBuilder().PUT(HttpRequest.BodyPublishers.ofString(body)).uri(this.serverURI.resolve("/hub/taskgroups/" + tg.id() + "/submit")).build(), HttpResponse.BodyHandlers.ofString());
            return switch (submitTG.statusCode()) {
                case 201, 204 -> new Result.Success<TaskGroup>(tg);
                default -> new Result.Failure(new Exception(String.format("Http client error %s, code %d", submitTG.body(), submitTG.statusCode())));
            };
        }
        catch (Exception e) {
            return new Result.Failure<TaskGroup>(e);
        }
    }

    @Override
    public Result<TaskGroup> get(int id) {
        try {
            HttpResponse<String> getTG = this.client.send(HttpRequest.newBuilder().GET().uri(this.serverURI.resolve("/hub/taskgroups/" + id)).build(), HttpResponse.BodyHandlers.ofString());
            if (getTG.statusCode() == 200) {
                TaskGroup tg = (TaskGroup)this.mapper.readValue(getTG.body(), (TypeReference)new TypeReference<TaskGroup>(){});
                return new Result.Success<TaskGroup>(tg);
            }
            return new Result.Failure<TaskGroup>(null);
        }
        catch (Throwable t) {
            return new Result.Failure<TaskGroup>(t);
        }
    }

    static class nonValidatingTrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

