/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.migrationtoolkit;

import com.redhat.parodos.tasks.migrationtoolkit.App;
import com.redhat.parodos.tasks.migrationtoolkit.Identity;
import com.redhat.parodos.tasks.migrationtoolkit.MTAApplicationClient;
import com.redhat.parodos.tasks.migrationtoolkit.MTAClient;
import com.redhat.parodos.tasks.migrationtoolkit.Repository;
import com.redhat.parodos.tasks.migrationtoolkit.Result;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.infrastructure.BaseInfrastructureWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.net.URI;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateApplicationTask
extends BaseInfrastructureWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CreateApplicationTask.class);
    protected MTAApplicationClient mtaClient;

    public CreateApplicationTask() {
    }

    public CreateApplicationTask(URI serverURL, String bearerToken) {
        this.mtaClient = new MTAClient(serverURL, bearerToken);
    }

    public WorkReport execute(WorkContext workContext) {
        Result<App> result;
        String branch;
        String identityName;
        String repo;
        String appName;
        try {
            appName = this.getOptionalParameterValue("applicationName", "");
            repo = this.getRequiredParameterValue("repositoryURL");
            identityName = this.getOptionalParameterValue("identity", null, false);
            if (this.mtaClient == null) {
                String serverUrl = this.getOptionalParameterValue("serverURL", null);
                String bearerToken = this.getOptionalParameterValue("bearerToken", null);
                this.mtaClient = new MTAClient(URI.create(serverUrl), bearerToken);
            }
            branch = this.getOptionalParameterValue("branch", null);
        }
        catch (MissingParameterException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        Identity identity = null;
        if (identityName != null) {
            identity = this.mtaClient.getIdentity(identityName);
        }
        if ((result = this.mtaClient.create(new App(0, appName, new Repository("git", repo, branch), new Identity[]{identity}))) == null) {
            this.taskLogger.logErrorWithSlf4j("MTA client returned empty result with no error", new String[0]);
            return new DefaultWorkReport(WorkStatus.REJECTED, new WorkContext(), (Throwable)new IllegalStateException("MTA client returned empty result with no error"));
        }
        if (result instanceof Result.Failure) {
            Result.Failure failure = (Result.Failure)result;
            this.taskLogger.logErrorWithSlf4j("MTA client returned failed result", new String[0]);
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, failure.t());
        }
        if (result instanceof Result.Success) {
            Result.Success success = (Result.Success)result;
            workContext.put("application", success.value());
            this.taskLogger.logInfoWithSlf4j("MTA client returned success result for application creation: {}", new String[]{((App)success.value()).name()});
            this.addAdditionInfo("VCS branch", repo);
            return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
        }
        throw new IllegalArgumentException();
    }
}

