/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.project;

import com.redhat.parodos.tasks.project.dto.NotificationRequest;
import com.redhat.parodos.utils.RestUtils;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.util.Arrays;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;

public class ProjectAccessRequestApprovalWorkFlowTask
extends BaseWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectAccessRequestApprovalWorkFlowTask.class);
    private final String serviceUrl;
    private final String servicePort;
    private final String notificationServiceUrl;
    private final String notificationServicePort;
    private final String notificationServiceAccountName;
    private final String notificationServiceAccountPassword;

    public ProjectAccessRequestApprovalWorkFlowTask(String serviceUrl, String servicePort, String notificationServiceUrl, String notificationServicePort, String notificationServiceAccountName, String notificationServiceAccountPassword) {
        this.serviceUrl = serviceUrl;
        this.servicePort = servicePort;
        this.notificationServiceUrl = notificationServiceUrl;
        this.notificationServicePort = notificationServicePort;
        this.notificationServiceAccountName = notificationServiceAccountName;
        this.notificationServiceAccountPassword = notificationServiceAccountPassword;
    }

    public WorkReport execute(WorkContext workContext) {
        String approvalUsernames;
        UUID accessRequestId;
        log.info("Start projectAccessRequestApprovalWorkFlowTask...");
        try {
            accessRequestId = UUID.fromString(this.getRequiredParameterValue("ACCESS_REQUEST_ID"));
            approvalUsernames = this.getRequiredParameterValue("ACCESS_REQUEST_APPROVAL_USERNAMES");
        }
        catch (MissingParameterException e) {
            log.error("Exception when trying to get required parameter(s): {}", (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        String projectAccessRequestStatusUrl = String.format("http://%s:%s/api/v1/projects/access/%s", this.serviceUrl, this.servicePort, accessRequestId);
        NotificationRequest request = NotificationRequest.builder().usernames(Arrays.stream(approvalUsernames.split(",")).toList()).subject("Project Access Request Approval").body(this.getMessage(projectAccessRequestStatusUrl)).build();
        HttpEntity<NotificationRequest> notificationRequestHttpEntity = RestUtils.getRequestWithHeaders(request, this.notificationServiceAccountName, this.notificationServiceAccountPassword);
        String url = String.format("http://%s:%s/api/v1/messages", this.notificationServiceUrl, this.notificationServicePort);
        ResponseEntity<String> response = RestUtils.executePost(url, notificationRequestHttpEntity);
        try {
            if (response.getStatusCode().is2xxSuccessful()) {
                log.info("Rest call completed: {}", response.getBody());
                return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
            }
            log.error("Call to the API was not successful. Response: {}", (Object)response.getStatusCode());
        }
        catch (Exception e) {
            log.error("There was an issue with the REST call: {}", (Object)e.getMessage());
        }
        return new DefaultWorkReport(WorkStatus.FAILED, workContext);
    }

    private String getMessage(String url) {
        return "Hi there,\nA project request awaits your approval. Use the url below to approve or reject the request.\nUrl: " + url + "\nThank you,\nThe Parodos Team";
    }
}

