/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.notification;

import com.redhat.parodos.notification.sdk.api.ApiException;
import com.redhat.parodos.notification.sdk.model.NotificationMessageCreateRequestDTO;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflow.task.enums.WorkFlowTaskOutput;
import com.redhat.parodos.workflow.task.infrastructure.Notifier;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class NotificationWorkFlowTask
extends BaseWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationWorkFlowTask.class);
    private final Notifier notifier;

    public NotificationWorkFlowTask(Notifier notifier) {
        this.notifier = notifier;
    }

    @NonNull
    public List<WorkParameter> getWorkFlowTaskParameters() {
        LinkedList<WorkParameter> params = new LinkedList<WorkParameter>();
        params.add(WorkParameter.builder().key("type").type(WorkParameterType.TEXT).optional(false).description("Message Type").build());
        params.add(WorkParameter.builder().key("body").type(WorkParameterType.TEXT).optional(false).description("Message Body").build());
        params.add(WorkParameter.builder().key("subject").type(WorkParameterType.TEXT).optional(false).description("Message Subject").build());
        params.add(WorkParameter.builder().key("userNames").type(WorkParameterType.TEXT).optional(true).description("Comma separated list of user names").build());
        params.add(WorkParameter.builder().key("groupNames").type(WorkParameterType.TEXT).optional(true).description("Comma separated list of group names").build());
        return params;
    }

    @NonNull
    public List<WorkFlowTaskOutput> getWorkFlowTaskOutputs() {
        return super.getWorkFlowTaskOutputs();
    }

    public HashMap<String, Map<String, Object>> getAsJsonSchema() {
        return super.getAsJsonSchema();
    }

    public WorkReport execute(WorkContext workContext) {
        NotificationMessageCreateRequestDTO notificationMessageCreateRequestDTO = new NotificationMessageCreateRequestDTO();
        try {
            notificationMessageCreateRequestDTO.messageType(this.getRequiredParameterValue("type"));
            notificationMessageCreateRequestDTO.body(this.getRequiredParameterValue("body"));
            notificationMessageCreateRequestDTO.subject(this.getRequiredParameterValue("subject"));
            List<String> userNames = this.toList(this.getOptionalParameterValue("userNames", null));
            List<String> groupNames = this.toList(this.getOptionalParameterValue("groupNames", null));
            if (CollectionUtils.isEmpty(userNames) && CollectionUtils.isEmpty(groupNames)) {
                throw new MissingParameterException("User Names or Group Names must be provided");
            }
            notificationMessageCreateRequestDTO.usernames(userNames);
            notificationMessageCreateRequestDTO.groupNames(groupNames);
        }
        catch (MissingParameterException e) {
            log.error("Exception when trying to get required parameter:", (Throwable)e);
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        try {
            this.notifier.trySend(notificationMessageCreateRequestDTO);
        }
        catch (ApiException e) {
            log.error("Exception when calling NotificationMessageApi#create:", (Throwable)e);
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    private List<String> toList(String str) {
        if (str == null) {
            return null;
        }
        return Arrays.asList(str.split("\\s*;\\s*"));
    }
}

