/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.migrationtoolkit;

import com.redhat.parodos.tasks.migrationtoolkit.App;
import com.redhat.parodos.tasks.migrationtoolkit.MTAApplicationClient;
import com.redhat.parodos.tasks.migrationtoolkit.MTAClient;
import com.redhat.parodos.tasks.migrationtoolkit.Result;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.infrastructure.BaseInfrastructureWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.net.URI;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetApplicationTask
extends BaseInfrastructureWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetApplicationTask.class);
    protected MTAApplicationClient mtaClient;

    public GetApplicationTask() {
    }

    public GetApplicationTask(URI serverURL, String bearerToken) {
        this.mtaClient = new MTAClient(serverURL, bearerToken);
    }

    public WorkReport execute(WorkContext workContext) {
        String applicationName = "";
        try {
            if (this.mtaClient == null) {
                String serverUrl = this.getOptionalParameterValue("serverURL", null);
                String bearerToken = this.getOptionalParameterValue("bearerToken", null);
                this.mtaClient = new MTAClient(URI.create(serverUrl), bearerToken);
            }
            applicationName = this.getRequiredParameterValue("applicationName");
        }
        catch (MissingParameterException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        Result<App> result = this.mtaClient.get(applicationName);
        if (result == null) {
            this.taskLogger.logErrorWithSlf4j("MTA client returned empty result with no error", new String[0]);
            return new DefaultWorkReport(WorkStatus.REJECTED, new WorkContext(), (Throwable)new IllegalStateException("MTA client returned empty result with no error"));
        }
        if (result instanceof Result.Failure) {
            Result.Failure failure = (Result.Failure)result;
            this.taskLogger.logErrorWithSlf4j("MTA client returned failed result", new String[0]);
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, failure.t());
        }
        if (result instanceof Result.Success) {
            Result.Success success = (Result.Success)result;
            this.addParameter("applicationID", String.valueOf(((App)success.value()).id()));
            this.taskLogger.logInfoWithSlf4j("MTA client returned success result for getting application with id: {}", new String[]{String.valueOf(((App)success.value()).id())});
            return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
        }
        throw new IllegalArgumentException();
    }
}

