/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.git;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.redhat.parodos.tasks.git.GitUtils;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import lombok.NonNull;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitArchiveTask
extends BaseWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitArchiveTask.class);

    @NonNull
    public List<WorkParameter> getWorkFlowTaskParameters() {
        return List.of(WorkParameter.builder().key("path").type(WorkParameterType.TEXT).optional(true).description("path where the git repo is located").build());
    }

    public String getRepoPath(WorkContext workContext) {
        return GitUtils.getRepoPath(workContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkReport execute(WorkContext workContext) {
        String path = this.getRepoPath(workContext);
        if (Strings.isNullOrEmpty((String)path)) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new IllegalArgumentException("The path parameter cannot be null or empty"));
        }
        try (Repository repo = null;){
            repo = this.getRepo(path);
            Path archivePath = this.archive(repo);
            workContext.put("gitArchivePath", (Object)archivePath.toAbsolutePath().toString());
        }
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    private Repository getRepo(String path) throws IOException {
        return GitUtils.getRepo(path);
    }

    private static void addFolderContentsToZip(File folder, String parentFolderPath, ZipOutputStream zos) throws IOException {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                GitArchiveTask.addFolderContentsToZip(file, parentFolderPath + "/" + file.getName(), zos);
                continue;
            }
            byte[] buffer = new byte[1024];
            try (FileInputStream fis = new FileInputStream(file);){
                int length;
                String entryPath = parentFolderPath + "/" + file.getName();
                ZipEntry entry = new ZipEntry(entryPath);
                zos.putNextEntry(entry);
                while ((length = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, length);
                }
                zos.closeEntry();
            }
        }
    }

    private Path archive(Repository repo) throws FileNotFoundException, IOException, GitAPIException {
        String tmpdir = Files.createTempDir().getAbsolutePath();
        Path zipFile = Paths.get(tmpdir + "/output.zip", new String[0]);
        Path repoDir = Path.of(repo.getDirectory().getAbsolutePath(), new String[0]).resolve("..");
        try (FileOutputStream fos = new FileOutputStream(zipFile.toAbsolutePath().toString());
             ZipOutputStream zos = new ZipOutputStream(fos);){
            GitArchiveTask.addFolderContentsToZip(repoDir.toFile(), "src", zos);
        }
        return zipFile;
    }

    @Generated
    public GitArchiveTask() {
    }
}

