/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.deploy;

import com.redhat.parodos.tasks.deploy.ManifestDeployException;
import com.redhat.parodos.workflow.context.WorkContextDelegate;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteIngress;
import io.fabric8.openshift.client.OpenShiftClient;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployApplicationTask
extends BaseWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployApplicationTask.class);
    private final OpenShiftClientCreator clientCreator;

    public DeployApplicationTask() {
        this.clientCreator = new DefaultOpenShiftClientCreator();
    }

    public DeployApplicationTask(OpenShiftClientCreator clientCreator) {
        this.clientCreator = clientCreator;
    }

    @NonNull
    public List<WorkParameter> getWorkFlowTaskParameters() {
        return List.of(WorkParameter.builder().key("kubeconfig").type(WorkParameterType.TEXT).optional(false).description("kubeconfig file of the target cluster in json format").build(), WorkParameter.builder().key("manifestsPath").type(WorkParameterType.TEXT).optional(false).description("The path to the manifests to deploy the application").build(), WorkParameter.builder().key("namespace").type(WorkParameterType.TEXT).optional(false).description("The namespace in which the application should be deployed").build());
    }

    public WorkReport execute(WorkContext workContext) {
        Set<Path> manifests;
        Input params;
        try {
            params = DeployApplicationTask.getTaskParameters(workContext);
        }
        catch (MissingParameterException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        try {
            manifests = DeployApplicationTask.loadManifests(params.manifestsPath);
        }
        catch (IOException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new RuntimeException("Failed to read manifest files from path %s with error %s".formatted(params.manifestsPath, e.getMessage()), e));
        }
        if (manifests.isEmpty()) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new RuntimeException("No manifest files found in path %s".formatted(params.manifestsPath)));
        }
        ArrayList hostnames = new ArrayList();
        try (OpenShiftClient osClient = this.createOpenShiftClient(params.kubeconfig);){
            for (Path manifest : manifests) {
                Optional.of(this.applyManifest(osClient, params.namespace, manifest)).ifPresent(hostnames::addAll);
            }
        }
        catch (ManifestDeployException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        catch (KubernetesClientException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new RuntimeException("Failed to create OpenShift client with error %s".formatted(e.getMessage()), e));
        }
        catch (Exception e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new RuntimeException("Failed to deploy manifests with error %s".formatted(e.getMessage()), e));
        }
        workContext.put("applicationHostnames", hostnames);
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    private static Set<Path> loadManifests(String manifestsPath) throws IOException {
        Set<Path> manifests;
        try (Stream<Path> walk = Files.walk(Paths.get(manifestsPath, new String[0]), new FileVisitOption[0]);){
            manifests = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(DeployApplicationTask::hasManifestSuffix).collect(Collectors.toSet());
        }
        return manifests;
    }

    private static boolean hasManifestSuffix(Path file) {
        return file.toString().endsWith(".yaml") || file.toString().endsWith(".yml") || file.toString().endsWith(".json");
    }

    private static Input getTaskParameters(WorkContext workContext) throws MissingParameterException {
        String kubeconfig = WorkContextDelegate.getRequiredValueFromRequestParams((WorkContext)workContext, (String)"kubeconfig");
        String manifestsPath = WorkContextDelegate.getRequiredValueFromRequestParams((WorkContext)workContext, (String)"manifestsPath");
        String namespace = WorkContextDelegate.getRequiredValueFromRequestParams((WorkContext)workContext, (String)"namespace");
        return new Input(kubeconfig, manifestsPath, namespace);
    }

    private List<String> applyManifest(OpenShiftClient osClient, String namespace, Path manifest) throws ManifestDeployException {
        List<String> list;
        block9: {
            log.info("Deploying manifest %s".formatted(manifest));
            InputStream stream = Files.newInputStream(manifest, new OpenOption[0]);
            try {
                List resources = (List)((ListVisitFromServerGetDeleteRecreateWaitApplicable)osClient.load(stream).inNamespace(namespace)).create();
                log.info("Manifest %s deployed successfully".formatted(manifest));
                list = this.getHostnamesFromRoute(osClient, resources);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ManifestDeployException("Failed to read manifest %s with error: %s".formatted(manifest, e.getMessage()), e);
                }
                catch (KubernetesClientException e) {
                    throw new ManifestDeployException("Failed to create manifest %s on cluster with error: %s".formatted(manifest, e.getMessage()), e);
                }
            }
            stream.close();
        }
        return list;
    }

    private List<String> getHostnamesFromRoute(OpenShiftClient osClient, List<HasMetadata> resources) throws ManifestDeployException {
        ArrayList<String> hostnames = new ArrayList<String>();
        for (HasMetadata resource : resources) {
            Route route;
            if (!"Route".equals(resource.getKind())) continue;
            String namespace = resource.getMetadata().getNamespace();
            String name = resource.getMetadata().getName();
            try {
                route = (Route)((Resource)((NonNamespaceOperation)osClient.routes().inNamespace(namespace)).withName(name)).get();
            }
            catch (KubernetesClientException e) {
                throw new ManifestDeployException("Failed to get route %s/%s with error: %s".formatted(namespace, name, e.getMessage()), e);
            }
            if (route != null) {
                hostnames.addAll(route.getStatus().getIngress().stream().map(RouteIngress::getHost).toList());
                continue;
            }
            throw new ManifestDeployException("Route %s/%s not found".formatted(namespace, name), null);
        }
        return hostnames;
    }

    private OpenShiftClient createOpenShiftClient(String kubeConfigString) {
        return this.clientCreator.create(kubeConfigString);
    }

    private static class DefaultOpenShiftClientCreator
    implements OpenShiftClientCreator {
        private DefaultOpenShiftClientCreator() {
        }

        @Override
        public OpenShiftClient create(String kubeConfigString) {
            Config config = Config.fromKubeconfig((String)kubeConfigString);
            return (OpenShiftClient)new KubernetesClientBuilder().withConfig(config).build().adapt(OpenShiftClient.class);
        }
    }

    static interface OpenShiftClientCreator {
        public OpenShiftClient create(String var1);
    }

    private record Input(String kubeconfig, String manifestsPath, String namespace) {
    }
}

