/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.migrationtoolkit;

import com.redhat.parodos.tasks.migrationtoolkit.MTAClient;
import com.redhat.parodos.tasks.migrationtoolkit.MTATaskGroupClient;
import com.redhat.parodos.tasks.migrationtoolkit.Result;
import com.redhat.parodos.tasks.migrationtoolkit.TaskGroup;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflow.task.infrastructure.BaseInfrastructureWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.net.URI;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmitAnalysisTask
extends BaseInfrastructureWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubmitAnalysisTask.class);
    protected MTATaskGroupClient mtaClient;

    public SubmitAnalysisTask() {
    }

    public SubmitAnalysisTask(URI serverURL, String bearerToken) {
        this.mtaClient = new MTAClient(serverURL, bearerToken);
    }

    @NonNull
    public List<WorkParameter> getWorkFlowTaskParameters() {
        return List.of(WorkParameter.builder().key("applicationName").type(WorkParameterType.TEXT).optional(false).description("The application name as presented in the application hub. Can be generated from the repository name").build(), WorkParameter.builder().key("serverURL").type(WorkParameterType.TEXT).optional(true).description("Base URL of the MTA instance - e.g https://mta-openshift-mta.app.clustername.clusterdomain").build(), WorkParameter.builder().key("bearerToken").type(WorkParameterType.TEXT).optional(true).description("Bearer token to authenticate server requests").build());
    }

    public WorkReport execute(WorkContext workContext) {
        int applicationID;
        try {
            applicationID = Integer.parseInt(this.getRequiredParameterValue("applicationID"));
            if (this.mtaClient == null) {
                String serverUrl = this.getOptionalParameterValue("serverURL", null);
                String bearerToken = this.getOptionalParameterValue("bearerToken", null);
                this.mtaClient = new MTAClient(URI.create(serverUrl), bearerToken);
            }
        }
        catch (MissingParameterException | NumberFormatException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, e);
        }
        Result<TaskGroup> result = this.mtaClient.create(applicationID);
        if (result == null) {
            return new DefaultWorkReport(WorkStatus.FAILED, new WorkContext(), (Throwable)new IllegalStateException("MTA client returned result with no error"));
        }
        if (result instanceof Result.Failure) {
            Result.Failure failure = (Result.Failure)result;
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, failure.t());
        }
        if (result instanceof Result.Success) {
            Result.Success success = (Result.Success)result;
            this.addParameter("taskGroupID", String.valueOf(((TaskGroup)success.value()).id()));
            return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
        }
        throw new IllegalArgumentException();
    }
}

